/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeadReplayAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(HeadReplayAutoSyncXxlJob.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String LOCK_KEY = "REPLAY_AUTO_SYNC_XXL_JOB_";

    @DynamicTaskService(cornExpression="0 0 1 1/1 1/1 ?", taskDesc="\u4e3b\u4f53\u8ba1\u7b97\u56de\u590d\u91cf\u5b9a\u65f6\u4efb\u52a1")
    public void replayAutoSyncXxlJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                return;
            }
            log.info("=====>    \u4e3b\u4f53\u3001\u7535\u5546\u8ba1\u7b97\u56de\u590d\u91cf[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            ArrayList<String> businessUnitCodeList = new ArrayList<String>();
            businessUnitCodeList.add(BusinessUnitEnum.HEADQUARTERS.getCode());
            businessUnitCodeList.add(BusinessUnitEnum.ONLINE.getCode());
            this.monthBudgetService.autoPlanReplay(DateUtil.format((Date)new Date(), (String)"yyyy-MM"), businessUnitCodeList, BooleanEnum.FALSE.getCapital());
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            log.info("=====>    \u4e3b\u4f53\u3001\u7535\u5546\u8ba1\u7b97\u56de\u590d\u91cf[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}

