/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HeadYearTotalAvailableBalanceSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(HeadYearTotalAvailableBalanceSyncXxlJob.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String LOCK_KEY = "YEAR_TOTAL_AVAILABLE_BALANCE_SYNC_XXL_JOB_";

    @DynamicTaskService(cornExpression="0 0 2 1 * ?", taskDesc="\u4e3b\u4f53\u8ba1\u7b97\u5e74\u5ea6\u7d2f\u8ba1\u53ef\u7528\u91d1\u989d\u5b9a\u65f6\u4efb\u52a1")
    public void calHeadYearTotalAvailableBalanceSyncXxlJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                return;
            }
            log.info("=====>    \u4e3b\u4f53\u8ba1\u7b97\u5e74\u5ea6\u7d2f\u8ba1\u53ef\u7528\u91d1\u989d[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            String yearMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM");
            this.monthBudgetService.calHeadYearTotalAvailableBalanceSyncXxlJob(yearMonth);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            log.info("=====>    \u4e3b\u4f53\u8ba1\u7b97\u5e74\u5ea6\u7d2f\u8ba1\u53ef\u7528\u91d1\u989d[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}

