/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class VerticalActualSalesAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(VerticalActualSalesAutoSyncXxlJob.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    private static final String DAY = "02";
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String LOCK_KEY = "ACTUAL_SALES_AUTO_SYNC_XXL_JOB_";

    public String getLockKey() {
        return LOCK_KEY;
    }

    @DynamicTaskService(cornExpression="0 0 2 2,10,20,24,27 1/1 ?", taskDesc="\uff08\u5782\u76f4\u5b9e\u9500\u91cf\uff09\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee\u5b9a\u65f6\u4efb\u52a1")
    public void actualSalesAutoSyncXxlJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = this.getLockKey() + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                return;
            }
            this.handle(null);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void handle(String yearMonth) {
        List ids;
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        ArrayList<String> businessUnitCodeList = new ArrayList<String>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        Calendar cl = Calendar.getInstance();
        String yearMonthDay = DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM-dd");
        String currDay = yearMonthDay.split("-")[2];
        if (DAY.equals(currDay)) {
            cl.add(2, -1);
        }
        if (StringUtils.isEmpty((CharSequence)yearMonth)) {
            yearMonth = DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM");
        }
        if (CollectionUtils.isEmpty((Collection)(ids = this.monthBudgetService.autoActualSales(yearMonth, businessUnitCodeList)))) {
            return;
        }
        Map actualSalesMap = this.monthBudgetService.calculateActualSales(ids);
        actualSalesMap.forEach((k, v) -> {
            ArrayList lockKeys = Lists.newArrayList();
            lockKeys.add(v.getMonthBudgetCode());
            boolean dataLock = true;
            try {
                dataLock = this.monthBudgetLockService.lock((List)lockKeys, TimeUnit.SECONDS, 5);
                if (dataLock) {
                    v.setDAY(DAY);
                    this.monthBudgetService.calculateActualReplyDiff(v, null);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (dataLock) {
                    this.monthBudgetLockService.unLock((List)lockKeys);
                }
            }
        });
    }
}

