/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalRollingAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(VerticalRollingAutoSyncXxlJob.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String DAY = "02";

    @DynamicTaskService(cornExpression="0 0 6 2 1/1 ?", taskDesc="\uff08\u5782\u76f4\uff09\u6eda\u52a8\u4e0a\u6708\u4f59\u989d")
    public void actualSalesAutoSyncXxlJob() {
        this.loginUserService.refreshAuthentication(null);
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        Calendar cl = Calendar.getInstance();
        this.handle(DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM"));
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }

    public void handle(String yearMonth) {
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf \u5e74\u6708 [{}] start {}   <=====", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
        ArrayList<String> businessUnitCodeList = new ArrayList<String>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        List ids = this.monthBudgetService.listByYearMonth(yearMonth, businessUnitCodeList);
        this.monthBudgetService.manualRolling(ids);
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf \u5e74\u6708 [{}] end {}   <=====", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
    }
}

