/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalWarningPanelXxlJob {
    private static final Logger log = LoggerFactory.getLogger(VerticalWarningPanelXxlJob.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String LOCK_KEY = "VERTICAL_WARNING_PANEL:";

    @DynamicTaskService(cornExpression="0 20 2 * * ?", taskDesc="\u5782\u76f4\u9884\u8b66\u9762\u677f-\u7ed9\u5e06\u8f6f\u8dd1")
    public void verticalAreaFeeWarningXxlJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                return;
            }
            log.info("=====>    \u5782\u76f4\u9884\u8b66\u9762\u677f-\u7ed9\u5e06\u8f6f\u8dd1[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            ArrayList yearMonths = Lists.newArrayList();
            YearMonth yearMonth = YearMonth.now();
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));
            yearMonth = yearMonth.plusMonths(-1L);
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));
            this.monthBudgetService.verticalWarningPanel((List)yearMonths);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            log.info("=====>    \u5782\u76f4\u9884\u8b66\u9762\u677f-\u7ed9\u5e06\u8f6f\u8dd1[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}

