package com.biz.crm.tpm.business.month.budget.sdk.dto;

import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 20:09
 */
@ApiModel(value = "MonthBudgetAdjustDto", description = "TPM-月度预算调整")
@Getter
@Setter
public class MonthBudgetAdjustDto {

    @ApiModelProperty(value = "调出方预算编码")
    private String adjustOutBudgetCode;

    @ApiModelProperty(value = "调出方预算集合")
    private List<MonthBudgetAdjustItemDto> adjustOutBudgetDtoList;

    @ApiModelProperty(value = "调出金额")
    private BigDecimal adjustOutAmount;

    @ApiModelProperty(value = "调入方预算编码")
    private String adjustInBudgetCode;

    @ApiModelProperty(value = "调入总金额")
    private BigDecimal adjustInAmount;

    @ApiModelProperty(value = "操作说明")
    private String operationRemarks;

    @ApiModelProperty("工作流参数")
    private ProcessBusinessDto processBusiness;
}