package com.biz.crm.tpm.business.month.budget.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年12月02日 11:28
 */
@ApiModel(value = "MonthBudgetBusinessPolicyQueryDto", description = "TPM-商务政策查询预算dto")
@Getter
@Setter
public class MonthBudgetBusinessPolicyQueryDto extends MonthBudgetDto {

    /**
     * 二级预算项目编码
     */
    @ApiModelProperty(value = "二级预算项目编码")
    private String secondBudgetItemCode;

    /**
     * 二级预算项目名称
     */
    @ApiModelProperty(value = "二级预算项目名称")
    private String secondBudgetItemName;

    /**
     * 二级预算项目可用余额
     */
    @ApiModelProperty(value = "二级预算项目可用余额")
    private BigDecimal secondBudgetItemBalance;

    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型编码", notes = "活动类型编码")
    private String activityTypeCode;

}
