package com.biz.crm.tpm.business.month.budget.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author huojia
 * @date 2022年10月27日 20:09
 */
@ApiModel(value = "MonthBudgetDto", description = "TPM-月度预算")
@Getter
@Setter
public class MonthBudgetControlQueryDto extends TenantFlagOpDto {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    private String groupCode;

    /**
     * 年月集合
     */
    @ApiModelProperty(value = "年月集合", notes = "")
    private List<String> yearMonthList;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCodeFlag;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]")
    private String feeBelongCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码")
    private String salesOrgCodeFlag;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    private String customerChannelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    private String customerChannelCodeFlag;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    private String terminalChannelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    private String terminalChannelCodeFlag;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码")
    private String systemCode;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码")
    private String systemCodeFlag;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCodeFlag;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCodeFlag;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCode;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCodeFlag;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCodeFlag;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCodeFlag;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码")
    private String productItemCode;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码")
    private String productItemCodeFlag;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String productCode;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String productCodeFlag;

    /**
     * 预算项目编码集合
     */
    @ApiModelProperty("预算项目编码集合")
    private List<String> sameBudgetItemCodeList;
}
