package com.biz.crm.tpm.business.month.budget.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 20:03
 */
@ApiModel(value = "MonthBudgetDetailDto", description = "TPM-月度预算明细")
@Getter
@Setter
public class MonthBudgetDetailDto extends TenantFlagOpDto {

    /**
     * 审批编码
     */
    @ApiModelProperty(value = "审批编码", notes = "")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态", notes = "")
    private String processStatus;

    /**
     * 年度预算编码（冗余字段）
     */
    @ApiModelProperty(value = "年度预算编码（冗余字段）")
    private String yearBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码")
    private String monthBudgetCode;

    /**
     * 业务编码
     */
    @ApiModelProperty(value = "业务编码")
    private String businessCode;

    /**
     * 操作类型[数据字典:tpm_budget_operation_type]
     */
    @ApiModelProperty(value = "操作类型[数据字典:tpm_budget_operation_type]")
    private String operationType;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    /**
     * 期初金额
     */
    @ApiModelProperty(value = "期初金额")
    private BigDecimal initialAmount;

    /**
     * 操作前金额
     */
    @ApiModelProperty(value = "操作前金额")
    private BigDecimal beforeAmount;

    /**
     * 当前操作金额
     */
    @ApiModelProperty(value = "当前操作金额")
    private BigDecimal curOperationAmount;

    /**
     * 操作后余额
     */
    @ApiModelProperty(value = "操作后余额")
    private BigDecimal balanceAmount;

    /**
     * 调出说明
     */
    @ApiModelProperty(value = "调出说明", notes = "")
    private String operationRemarks;

    /**
     * 已结案金额
     */
    private BigDecimal alreadyEndCaseAmount;

    /**
     * 方案退预算发生年月
     */
    @ApiModelProperty("方案退预算发生年月")
    private String planReturnBudgetYearAndMonth;

    @ApiModelProperty("核销明细码")
    private String auditCode;

    @ApiModelProperty("是否驳回")
    private String reject;

    @ApiModelProperty("是否修改结案金额")
    private String changeAuditAmount;

    @ApiModelProperty("是否修改批复结案差")
    private String changeApprovedAuditDiff;

    @ApiModelProperty("是否修改调整金额")
    private String changeAdjustAmount;

    @ApiModelProperty("是否修改累计可用余额")
    private String changeAccumulatedAvailableBalance;

    @ApiModelProperty("是否修改冻结后可用金额")
    private String changeAfterFreezeAmount;
}
