package com.biz.crm.tpm.business.month.budget.sdk.dto;

import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 20:09
 */
@ApiModel(value = "MonthBudgetOperateDto", description = "TPM-月度预算操作")
@Getter
@Setter
public class MonthBudgetOperateDto {

    @ApiModelProperty(value = "月度预算编码")
    private String monthBudgetCode;

    @ApiModelProperty(value = "操作金额")
    private BigDecimal operationAmount;

    @ApiModelProperty(value = "操作类型")
    private String operationType;

    @ApiModelProperty(value = "操作说明")
    private String operationRemarks;

    @ApiModelProperty("工作流参数")
    private ProcessBusinessDto processBusiness;
}