package com.biz.crm.tpm.business.month.budget.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 操作月度预算Dto
 *
 * @author wanghaojia
 * @date 2023/1/9 16:35
 */
@Data
public class OperateMonthBudgetDto {

    /**
     * 行（给数据加上索引）
     */
    private Integer indexNo;

    /**
     * 月度预算编码
     */
    private String monthBudgetCode;

    /**
     * 操作金额
     */
    private BigDecimal operationAmount;

    /**
     * 预算类型   分子公司月度预算/月度预算    MonthBudgetTypeEnum
     */
    private String budgetType;

    /**
     * 操作类型   BudgetOperationTypeEnum
     */
    private String operationType;

    /**
     * 是否执行保存方法，默认为true
     */
    private Boolean doSave = true;

    /**
     * 是否抛异常，默认为true
     */
    private Boolean throwException = true;

    /**
     * 差额
     */
    private BigDecimal gapAmount;

    /**
     * 业务编码
     */
    private String businessCode;

    private String businessUnitCode;

    /**
     * 已结案金额
     */
    private BigDecimal alreadyEndCaseAmount;

    @ApiModelProperty("方案退预算发生年月")
    private String planReturnBudgetYearAndMonth;

    @ApiModelProperty("核销明细码")
    private String auditCode;

    @ApiModelProperty("是否测试")
    private boolean test;

    @ApiModelProperty("是否修改结案金额")
    private String changeAuditAmount;

    @ApiModelProperty("是否修改批复结案差")
    private String changeApprovedAuditDiff;

    @ApiModelProperty("是否修改调整金额")
    private String changeAdjustAmount;

    @ApiModelProperty("是否修改累计可用余额")
    private String changeAccumulatedAvailableBalance;

    @ApiModelProperty("是否修改冻结后可用金额")
    private String changeAfterFreezeAmount;

}
