package com.biz.crm.tpm.business.month.budget.sdk.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 操作月度预算Dto
 *
 * @author wanghaojia
 * @date 2023/1/9 16:35
 */
@Data
public class PromotionOperateMonthBudgetDto {

    /**
     * 月度预算编码
     */
    private String monthBudgetCode;

    /**
     * 费用率
     */
    private BigDecimal feeRatio;

    /**
     * 操作金额
     */
    private BigDecimal operationAmount;

    /**
     * 预算类型   分子公司月度预算/月度预算    MonthBudgetTypeEnum
     */
    private String budgetType;

    /**
     * 操作类型   BudgetOperationTypeEnum
     */
    private String operationType;

    /**
     * 是否执行保存方法，默认为true
     */
    private Boolean doSave = true;

    /**
     * 业务编码
     */
    private String businessCode;

}
