package com.biz.crm.tpm.business.month.budget.sdk.dto;


import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 分子公司寻预算维度
 */
@Data
public class SonComBugdetDimensionalityDto {
    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元(冗余字段)", notes = "")
    private String businessUnitCode;

    /**
     * 业态
     */
    @ApiModelProperty(value = "业态(冗余字段)", notes = "")
    private String businessFormatCode;

    @ApiModelProperty(value = "流程状态(冗余字段)", notes = "")
    private String processStatus;

    @ApiModelProperty(name = "orgCode", notes = "主列表上的组织编码(冗余字段)")
    private String orgCode;

    @ApiModelProperty(name = "activityTemplateCode", notes = "活动模板编码")
    private String activityTemplateCode;

    @ApiModelProperty(name = "constituentDetailPlanCode", notes = "分子公司活动细案")
    private String constituentDetailPlanCode;


    @ApiModelProperty(name = "constituentDetailPlanName", notes = "分子公司活动细案名称")
    private String constituentDetailPlanName;


    @ApiModelProperty(name = "constituentDetailPlanItemCode", notes = "分子公司活动细案明细编码")
    private String constituentDetailPlanItemCode;

    @ApiModelProperty(name = "constituentDetailPlanItemName", notes = "分子公司活动细案明细编码")
    private String constituentDetailPlanItemName;

    @ApiModelProperty(name = "activityStatus", notes = "活动状态")
    private String activityStatus;

    @ApiModelProperty("关联类型")
    private String associationType;


    @ApiModelProperty("承接方式")
    private String undertakingMode;


    @ApiModelProperty("关联数据编码")
    private String associatedDateCode;


    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;


    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("活动形式说明")
    private String activityFormDesc;

    @ApiModelProperty(name = "分摊费用到产品", notes = "分摊费用到产品")
    private Boolean allocationFeeToProduct;

    @ApiModelProperty("结案形式")
    private String auditForm;

    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String paymentMethod;

    @ApiModelProperty("核销方式")
    private String auditType;


    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;


    @ApiModelProperty(name = "核销公式名称", notes = "核销公式名称")
    private String auditFormulaName;


    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;


    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;


    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty("是否公用量")
    private String  isSupplyAmount;

    @ApiModelProperty("活动号")
    private String  activityNumber;

    @ApiModelProperty("公用组")
    private String  commonGroups;

    @ApiModelProperty("客户编码")
    private String customerCode;


    @ApiModelProperty("客户名称")
    private String customerName;


    @ApiModelProperty("资产编号")
    private String assetNo;


    @ApiModelProperty("资产标牌号码")
    private String assetBadgeNumber;


    @ApiModelProperty("规格型号")
    @TableField(value = "spec_model")
    private String specModel;


    @ApiModelProperty("品牌名称")
    @TableField(value = "brand_name")
    private String productBrandName;


    @ApiModelProperty("品牌编码")
    @TableField(value = "brand_code")
    private String productBrandCode;


    @ApiModelProperty("资产采购金额")
    private BigDecimal purchaseAmount;


    @ApiModelProperty("已返还金额")
    private BigDecimal refundAmount;


    @ApiModelProperty("本次返还金额")
    private BigDecimal thisRefundAmount;


    @ApiModelProperty("剩余未返还金额")
    private BigDecimal remainingRefundAmount;


    @ApiModelProperty("公司承担金额")
    private BigDecimal companyBorneAmount;

    @ApiModelProperty("公司自投金额")
    private BigDecimal subComAutoAmount;


    @ApiModelProperty("总部支持金额")
    private BigDecimal headquartersSupportedAmount;

    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门编码")
    private String departmentCode;

    /**
     * 方案结束时间
     */
    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("门店编码")
    private String terminalCode;


    @ApiModelProperty("门店名称")
    private String terminalName;


    /**
     * 零售商
     */
    @ApiModelProperty(name = "零售商", notes = "零售商")
    private String resaleCommercialCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    private String resaleCommercialName;

    @ApiModelProperty("地址")
    private String address;


    @ApiModelProperty("联系人")
    private String contact;


    @ApiModelProperty("联系电话")
    private String contactPhone;


    @ApiModelProperty("资产属性")
    private String assetAttributes;


    @ApiModelProperty("使用状态")
    private String useStatus;


    @ApiModelProperty("投放年份")
    private String releaseYear;


    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项名称")
    private String productItemName;


    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品编码")
    private String productName;

    @ApiModelProperty(name = "促销产品生产年月", notes = "促销产品生产年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    private Date proProductYearMonth;


    @ApiModelProperty("推广场次")
    private Integer promoteNumber;


    @ApiModelProperty("单场预估费用")
    private BigDecimal singleEstimatedCost;


    @ApiModelProperty("费用合计")
    private BigDecimal totalCost;


    @ApiModelProperty("客户承担金额")
    private BigDecimal customerFeeAmount;

    @ApiModelProperty("自定义核销编码")
    private String customAuditCode;

    @ApiModelProperty("核销条件")
    private String auditCondition;

    @ApiModelProperty("自定义核销名称")
    private String customAuditName;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    private String auditConditionName;


    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    private String supplierName;

    /**
     * 采购类型
     */
    @ApiModelProperty("采购类型")
    private String procurementType;

    @ApiModelProperty("物料编码")
    @TableField(value = "material_code")
    private String materialCode;


    @ApiModelProperty("物料名称")
    @TableField(value = "material_name")
    private String materialName;


    @ApiModelProperty("物料数量")
    private BigDecimal quantity;


    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("帐期")
    private String accountPeriod;

    @ApiModelProperty("物料单位")
    private String materialUnitCode;

    @ApiModelProperty("物料单位名称")
    private String materialUnitName;

    @ApiModelProperty("物料单价")
    private BigDecimal materialPrice;


    @ApiModelProperty("是否做费用池扣款")
    private String isFeePoolDeduction;


    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;


    @ApiModelProperty("分销渠道")
    private String distributionChannelName;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;



    @ApiModelProperty("管理分级代码")
    private String managementClassificationCode;


    @ApiModelProperty("管理分级")
    private String managementClassificationName;


    @ApiModelProperty("促销员类型")
    private String promoterType;


    @ApiModelProperty("促销员人数")
    private String promoterNumber;


    @ApiModelProperty("促销员单价")
    private BigDecimal promoterPrice;

    @ApiModelProperty("门店预计月销售额")
    private BigDecimal terminalMonthSalesAmount;


    @ApiModelProperty("上月门店实际月销售额")
    private BigDecimal terminalMonthSalesLastAmount;


    @ApiModelProperty("订单开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date orderStartDate;


    @ApiModelProperty("订单结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date orderEndDate;


    @ApiModelProperty("陈列类型")
    private String displayType;


    @ApiModelProperty("陈列单价")
    private BigDecimal displayPrice;


    @ApiModelProperty("陈列数量")
    private BigDecimal displayNumber;


    @ApiModelProperty("是否大日期")
    private String isBigDate;


    @ApiModelProperty("大日期批次")
    private String bigDateNo;


    @ApiModelProperty(name = "unitCode", value = "单位编码", notes = "单位编码")
    private String unitCode;


    @ApiModelProperty(name = "unit", value = "单位", notes = "单位")
    private String unit;

    @ApiModelProperty("原品单价（元）")
    private BigDecimal originalProductPrice;


    @ApiModelProperty("活动价（元）")
    private BigDecimal activityPrice;


    @ApiModelProperty("原品数量")
    private BigDecimal originalProductNumber;


    @ApiModelProperty(name = "赠品编码", notes = "赠品编码")
    private String giftProductCode;


    @ApiModelProperty(name = "赠品名称", notes = "赠品名称")
    private String giftProductName;


    @ApiModelProperty(name = "赠品单价", notes = "赠品单价")
    private BigDecimal giftProductPrice;


    @ApiModelProperty("赠品数量")
    private BigDecimal giftProductNumber;


    @ApiModelProperty("是否关联促销政策")
    private String isAssPromotion;


    /**
     * 促销政策编码
     */
    @ApiModelProperty("促销政策编码")
    private String promotionCode;


    /**
     * 促销政策名称
     */
    @ApiModelProperty("促销政策名称")
    private String promotionName;

    /**
     * 活动力度说明
     */
    @ApiModelProperty("活动力度说明")
    private String activityIntensity;

    /**
     * 是否20门店
     */
    @ApiModelProperty("是否20门店")
    private String isTwentyStores;

    /**
     * 期间促销量
     */
    @ApiModelProperty("期间促销量")
    private BigDecimal promoteSales;

    /**
     * 期间促销额（元）
     */
    @ApiModelProperty("期间促销额（元）")
    private BigDecimal promotionAmount;

    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    private String activityDesc;
    /**
     * 促销活动号
     */
    @ApiModelProperty("促销活动号")
    @Column(name = "promotion_no", length = 32, columnDefinition = "varchar(32) COMMENT '促销活动号'")
    private String promotionNo;


    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

    @ApiModelProperty("完全结案日期")
    private String wholeAuditDate;

    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;

    /**
     * 是否完全上账
     */
    @ApiModelProperty("是否完全上账")
    private String wholeUpAccount;
    /**
     * 已上账金额
     */
    @ApiModelProperty("已上账金额")
    private BigDecimal alreadyUpAccountAmount;
    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;


    @ApiModelProperty("推送订单共享平台状态标记")
    private String orderShareInterfaceState;

    @ApiModelProperty("推送sap状态标记")
    private String sapInterfaceState;

    @ApiModelProperty("是否价格相关")
    private String isPriceRelation;

    @ApiModelProperty("是否巡查")
    private String isPatrolOperations;


    /**
     * 销售组(省区)
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组(省区)",notes = "销售组(省区)")
    private String salesGroupName;
    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    private String salesGroupCode;




    /**
     * 人员数量
     */
    @ApiModelProperty("人员数量")
    private BigDecimal personNumber;
    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    private String personIdCard;
    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    private String personType;
    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    private String personName;
    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    private String personCode;
    /**
     * 是否档期
     */
    @ApiModelProperty("是否档期")
    private String whetherScheduleTime;

    @ApiModelProperty("档期时间 格式：2023-01-10至2023-02-28")
    private String scheduleTimeStr;

    @ApiModelProperty("档期开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleStartTime;


    @ApiModelProperty("档期结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date scheduleEndTime;

    /**
     * 当前变更版本号
     */
    @ApiModelProperty("当前变更版本号")
    private String currModifyCode;

    /**
     * 是否变更过Y/N
     */
    private String hasModify;

    @ApiModelProperty("自动核销")
    private String autoAudit;

    /**
     * 释放金额
     */
    @ApiModelProperty("释放金额")
    private BigDecimal returnAmount;

    /**
     * 关闭金额
     */
    @ApiModelProperty("关闭金额")
    private BigDecimal closeAmount;
}
