package com.biz.crm.tpm.business.month.budget.sdk.dto;

import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigSalesOrgVo;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/5/13 14:37
 * @description: 获取年度总点数之和
 */
@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class YearBudgetEventDto implements NebulaEventDto {

    @ApiModelProperty(value = "年度预算编码", notes = "")
    private String yearBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 预算类型[数据字典:tpm_budget_type]
     */
    @ApiModelProperty(value = "预算类型[数据字典:tpm_budget_type]")
    private String budgetTypeCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 管控类型
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    private String controlType;

    /**
     * 包含销售组织集合[数据字典:tpm_org_area]
     */
    @ApiModelProperty(value = "包含销售组织集合[数据字典:tpm_org_area]", notes = "包含销售组织集合[数据字典:tpm_org_area]")
    private List<BudgetCalConfigSalesOrgVo> salesOrgList;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织范围[数据字典:tpm_org_area]
     */
    @ApiModelProperty(name = "销售组织范围[数据字典:tpm_org_area]", notes = "销售组织范围[数据字典:tpm_org_area]")
    private String orgAreaCode;

    /**
     * 年
     */
    @ApiModelProperty(value = "年", notes = "")
    private String yearLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    @ApiModelProperty("分组")
    private String groupCode;

    @ApiModelProperty("客户编码")
    private String customerCode;
}
