package com.biz.crm.tpm.business.month.budget.sdk.eunm;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Description: 核销使用预算类型
 * @Author: dengwei
 * @Date: 2023/3/1 0:44
 * @Version: 1.0
 */
@Getter
@AllArgsConstructor
public enum AuditUseBudgetTypeEnum {
    USE("use","使用预算"),
    RETURN("return","退回预算"),
    USE_RETURN("use_return","使用预算的退回");
    private String value;
    private String name;

    public static AuditUseBudgetTypeEnum getEnumByValue(String value){
        for (AuditUseBudgetTypeEnum auditUseBudgetTypeEnum : AuditUseBudgetTypeEnum.values()) {
            if(auditUseBudgetTypeEnum.getValue().equals(value)){
                return auditUseBudgetTypeEnum;
            }
        }
        return null;
    }
}
