package com.biz.crm.tpm.business.month.budget.sdk.eunm;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年11月01日 11:27
 */
@Getter
public enum BudgetOperationTypeEnum {

    /**
     * INIT
     */
    INIT("init", "期初"),

    /**
     * ADJUST_OUT
     */
    ADJUST_OUT("adjust_out", "调出"),

    /**
     * ADJUST_IN
     */
    ADJUST_IN("adjust_in", "调入"),
    /**
     * ADJUST
     */
    ADJUST("adjust", "调整"),

    /**
     * TRANSFER_OUT
     */
    TRANSFER_OUT("transfer_out", "拨出"),

    /**
     * TRANSFER_IN
     */
    TRANSFER_IN("transfer_in", "拨入"),

    /**
     * ADD
     */
    ADD("add", "追加"),

    /**
     * 扣减
     */
    DEDUCTION("deduction", "扣减"),

    /**
     * SUBTRACT
     */
    SUBTRACT("subtract", "削减"),

    /**
     * 冻结
     */
    FREEZE("freeze", "冻结"),

    /**
     * 解冻
     */
    UNFREEZE("unfreeze", "解冻"),

    /**
     * 使用
     */
    USE("use", "使用"),

    /**
     * 退回
     */
    RETURN("return", "退回"),

    /**
     * 计划
     */
    PLAN("plan", "计划"),

    /**
     * 回复
     */
    REPLAY("replay", "回复"),

    /**
     * 释放
     */
    RELEASE("release", "释放"),

    /**
     * 结案差
     */
    AUDIT_DIFF("audit_diff", "结案差"),

    /**
     * 实销
     */
    ACTUAL_SALES("actual_sales", "实销"),

    /**
     * 预估超额
     */
    FORECAST_OVER("forecast_over", "预估超额"),

    /**
     * 责任利润调整
     */
    DUTY_PROFIT_ADJUST("duty_profit_adjust", "责任利润调整"),

    /**
     * 考核扣减
     */
    EXAMINE_CIRCULAR_SUBTRACT("examine_circular_subtract", "考核扣款"),

    /**
     * 考核奖励
     */
    EXAMINE_CIRCULAR_ADD("examine_circular_add", "考核奖励"),

    AUDIT_USE("audit_use","核销使用"),
    AUDIT_REJECT("audit_reject","核销驳回"),
    AUDIT_RETURN("audit_return","核销退回"),

    /**
     * 滚动
     */
    ROLLING("rolling", "滚动"),

    IMPORT("import", "导入"),
    ;

    private final String code;

    private final String des;

    BudgetOperationTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    /**
     * 调整map
     *
     * @return java.util.Map<java.lang.String, java.lang.Integer>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, String> adjustMap() {
        Map<String, String> map = new HashMap<>();
        map.put(ADJUST_OUT.getCode(), ADJUST_OUT.getDes());
        map.put(ADJUST_IN.getCode(), ADJUST_IN.getDes());
        return map;
    }

    /**
     * 变更map
     *
     * @return java.util.Map<java.lang.String, java.lang.Integer>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, String> changeMap() {
        Map<String, String> map = new HashMap<>();
        map.put(ADD.getCode(), ADD.getDes());
        map.put(SUBTRACT.getCode(), SUBTRACT.getDes());
        return map;
    }

    /**
     * 冻结、解冻map
     *
     * @return java.util.Map<java.lang.String, java.lang.Integer>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static Map<String, String> freezeMap() {
        Map<String, String> map = new HashMap<>();
        map.put(FREEZE.getCode(), FREEZE.getDes());
        map.put(UNFREEZE.getCode(), UNFREEZE.getDes());
        return map;
    }
}
