package com.biz.crm.tpm.business.month.budget.sdk.eunm;

import lombok.Getter;

@Getter
public enum FeeSourceEnum {

    INTERNAL_POINT_FEE("internal_point_fee", "点内费用"),

    OFF_POINT_FEE("off_point_fee", "点外费用"),

    AUTO_FEE("auto_fee", "自投费用"),

    ;

    private String code;

    private String desc;

    FeeSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static FeeSourceEnum codeToEnum(String code){
        for (FeeSourceEnum sourceEnum :FeeSourceEnum.values()){
            if (sourceEnum.getCode().equals(code)){
                return sourceEnum;
            }
        }
        return null;
    }


}
