package com.biz.crm.tpm.business.month.budget.sdk.eunm;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

/**
 * @author huojia
 * @date 2022年11月07日 10:19
 */
@Getter
public enum MonthBudgetGroupEnum {

    /**
     * 部门
     */
    organization("organization", "部门"),
    channel("channel", "渠道"),
    system("system", "零售商"),
    customer("customer", "客户"),
    terminal("terminal", "门店")

    ;

    private final String code;

    private final String des;

    MonthBudgetGroupEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    /**
     * 得到枚举通过编码
     *
     * @param code
     *            编码
     * @return {@link MonthBudgetGroupEnum}
     */
    public static MonthBudgetGroupEnum getEnumByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        for (MonthBudgetGroupEnum value : MonthBudgetGroupEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}