package com.biz.crm.tpm.business.month.budget.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月03日 14:22
 */
@Getter
public enum MonthEnum {
    /**
     * 一月份
     */
    JANUARY("01", "一月"),

    /**
     * 二月份
     */
    FEBRUARY("02", "二月"),

    /**
     * 三月份
     */
    MARCH("03", "三月"),

    /**
     * 四月份
     */
    APRIL("04", "四月"),

    /**
     * 五月份
     */
    MAY("05", "五月"),

    /**
     * 六月份
     */
    JUNE("06", "六月"),

    /**
     * 七月份
     */
    JULY("07", "七月"),

    /**
     * 八月份
     */
    AUGUST("08", "八月"),

    /**
     * 九月份
     */
    SEPTEMBER("09", "九月"),

    /**
     * 十月份
     */
    OCTOBER("10", "十月"),

    /**
     * 十一月份
     */
    NOVEMBER("11", "十一月"),

    /**
     * 十二月份
     */
    DECEMBER("12", "十二月");

    private String code;
    private String desc;

    MonthEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 将枚举转换为list
     *
     * @return java.util.List<java.lang.String>
     * @author huojia
     * @date 2022/11/3 14:30
     **/
    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (MonthEnum t : MonthEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }
}
