package com.biz.crm.tpm.business.month.budget.sdk.event;

import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author huojia
 * @date 2022年10月26日 11:53
 */
public interface MonthBudgetLogEventListener extends NebulaEvent {

    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(MonthBudgetLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(MonthBudgetLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(MonthBudgetLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(MonthBudgetLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(MonthBudgetLogEventDto dto);
}
