package com.biz.crm.tpm.business.month.budget.sdk.event;

import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author huojia
 * @date 2022年10月26日 11:53
 */
public interface SubComMonthBudgetLogEventListener extends NebulaEvent {

    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(SubComMonthBudgetLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(SubComMonthBudgetLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(SubComMonthBudgetLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(SubComMonthBudgetLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(SubComMonthBudgetLogEventDto dto);
}
