package com.biz.crm.tpm.business.month.budget.sdk.service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author huojia
 * @date 2022年11月01日 14:50
 */
public interface MonthBudgetLockService {

    /**
     * 根据预算编码加锁
     *
     * @param monthBudgetCode
     * @param timeUnit
     * @param time
     * @return boolean
     * @author huojia
     * @date 2022/11/1 14:21
     **/
    boolean lock(String monthBudgetCode, TimeUnit timeUnit, int time);

    /**
     * 是否锁定
     *
     * @param monthBudgetCode
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-13 23:49
     */
    boolean isLock(String monthBudgetCode);

    /**
     * 根据预算编码批量加锁
     *
     * @param monthBudgetCodeList
     * @param timeUnit
     * @param time
     * @return boolean
     * @author huojia
     * @date 2022/11/1 14:21
     **/
    boolean lock(List<String> monthBudgetCodeList, TimeUnit timeUnit, int time);

    /**
     * 是否锁定
     *
     * @param monthBudgetCodeList
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-13 23:49
     */
    boolean isLock(List<String> monthBudgetCodeList);


    /**
     * 根据预算编码批量加锁
     *
     * @param monthBudgetCodeList
     * @param timeUnit
     * @param lockTime
     * @param waiteTime
     * @return boolean
     * @author huojia
     * @date 2022/11/1 14:21
     **/
    boolean lock(List<String> monthBudgetCodeList, TimeUnit timeUnit, int lockTime, int waiteTime);

    /**
     * 解锁
     *
     * @param monthBudgetCode
     * @author huojia
     * @date 2022/11/1 14:46
     **/
    void unLock(String monthBudgetCode);

    /**
     * 批量解锁
     *
     * @param monthBudgetCodeList
     * @author huojia
     * @date 2022/11/1 14:46
     **/
    void unLock(List<String> monthBudgetCodeList);

}
