package com.biz.crm.tpm.business.month.budget.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.tpm.business.month.budget.sdk.dto.*;
import com.biz.crm.tpm.business.month.budget.sdk.vo.*;
import com.google.common.collect.Lists;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author huojia
 * @date 2022年10月27日 20:10
 */
public interface MonthBudgetService {

    /**
     * 分页查询月度预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/10/27 20:18
     **/
    Page<MonthBudgetVo> findByConditions(Pageable pageable, MonthBudgetDto dto);

    /**
     * 分页查询月度预算  不要他们那个过滤逻辑。。。
     */
    Page<MonthBudgetVo> findByConditionsNoFilter(Pageable pageable, MonthBudgetDto dto);

    /**
     * 分页查询所有数据（包含分子公司）
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2023/1/30 9:50
     **/
    Page<MonthBudgetVo> findUnionByConditions(Pageable pageable, MonthBudgetDto dto);

    /**
     * 根据预算编码批量查询数据
     * @param codes
     * @return
     */
    List<MonthBudgetVo> findUnionListByCodes(List<String> codes);

    /**
     * 条件查询月度预算
     *
     * @param dto
     * @return
     */
    List<MonthBudgetVo> findListByConditions(MonthBudgetDto dto);

    /**
     * 编辑
     *
     * @param dto
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo
     * @author huojia
     * @date 2022/10/27 20:40
     **/
    MonthBudgetVo update(MonthBudgetDto dto);

    /**
     * 根据主键查询
     *
     * @param id
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo
     * @author huojia
     * @date 2022/10/27 20:44
     **/
    MonthBudgetVo findById(String id);

    /**
     * 根据月度预算编码查询
     *
     * @param code
     * @param enableStatus
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo
     * @author huojia
     * @date 2022/10/27 20:44
     **/
    MonthBudgetVo findByCode(String code, String enableStatus);

    /**
     * 根据月度预算编码批量查询
     *
     * @param codes
     * @param enableStatus
     * @author wanghaojia
     * @date 2022/11/11 14:15
     **/
    List<MonthBudgetVo> findByCodes(List<String> codes, String enableStatus);

    /**
     * 月度预算调整
     *
     * @param dto
     * @author huojia
     * @date 2022/11/1 10:06
     **/
    void adjust(MonthBudgetAdjustDto dto);

    /**
     * 月度预算调整(新)
     * @param dto
     */
    void monthBudgetAdjust(MonthBudgetAdjustDto dto);

    /**
     * 月度预算变更
     *
     * @param dto
     * @author huojia
     * @date 2022/11/1 15:32
     **/
    void change(MonthBudgetOperateDto dto);

    /**
     * 月度预算冻结、解冻
     *
     * @param dto
     * @param operationType
     * @author huojia
     * @date 2022/11/1 16:51
     **/
    void unOrFreeze(MonthBudgetOperateDto dto, String operationType);

    /**
     * 根据预算项目编码批量查询预算
     *
     * @param budgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/11/1 20:39
     **/
    List<MonthBudgetVo> listByBudgetItemCodeList(List<String> budgetItemCodeList);

    /**
     * 批量新增月度预算（通过年度预算生成）（仅年度预算可使用该接口）
     *
     * @param monthBudgetDtoList
     * @author huojia
     * @date 2022/11/3 14:37
     **/
    void saveBatch(List<MonthBudgetDto> monthBudgetDtoList);

    /**
     * 根据年度预算查询对应月度预算
     *
     * @param yearBudgetCode
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/11/3 21:11
     **/
    List<MonthBudgetVo> listByYearBudgetCode(String yearBudgetCode);

    /**
     * 月度预算批量编辑（异步计算时调用，已保证参数正确，不做参数校验，其他地方不能用！！！）
     *
     * @param monthBudgetDtoList
     * @author huojia
     * @date 2022/11/4 11:43
     **/
    void updateBatch(List<MonthBudgetDto> monthBudgetDtoList);

    /**
     * 年度预算编码集合
     *
     * @param yearBudgetCodeList
     * @author huojia
     * @date 2022/11/5 16:37
     **/
    void delByYearBudgetCode(List<String> yearBudgetCodeList);

    /**
     * 其他模块使用
     * <p>
     * 操作月度预算（月度预算编码、操作金额、预算类型、操作类型必填，业务编码非必填）
     *
     * @param monthBudgetCode
     * @param operationAmount
     * @param budgetType
     * @param operationType
     * @param businessCode
     */
    void operateBudget(String monthBudgetCode, BigDecimal operationAmount, String budgetType, String operationType, String businessCode);

    /**
     * 其他模块使用
     * <p>
     * 操作月度预算（月度预算编码、操作金额、预算类型、操作类型必填，业务编码非必填）
     *
     * @param promotionOperateMonthBudgetDtoList
     */
    void operatePromotionBudget(List<PromotionOperateMonthBudgetDto> promotionOperateMonthBudgetDtoList);

    /**
     * 本模块使用
     * <p>
     * 操作月度预算（月度预算编码、操作金额、操作类型必填）
     *
     * @param monthBudgetCode
     * @param feeRatio
     * @param operationAmount
     * @param operationType
     * @param businessCode
     * @author huojia
     * @date 2022/11/7 10:39
     **/
    void operateBudget(String monthBudgetCode, BigDecimal feeRatio, BigDecimal operationAmount, String operationType, String businessCode);

    /**
     * 本模块使用
     * <p>
     * 批量操作月度预算（月度预算编码、操作金额、操作类型必填）
     *
     * @author wanghaojia
     * @date 2023/1/9 16:35
     **/
    void operateBudget(List<OperateMonthBudgetDto> operateList);

    @Transactional(rollbackFor = Exception.class)
    void operateBudget(List<OperateMonthBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap);

    /**
     * 本模块使用
     * <p>
     * 批量操作月度预算的策略占用金额
     **/
    void operateBudgetStrategy(List<OperateMonthBudgetDto> operateList);

    void operateBudgetStrategy(List<OperateMonthBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap);

    /**
     * 划拨
     *
     * @param dto
     * @author huojia
     * @date 2022/11/7 19:55
     **/
    void transfer(MonthBudgetTransferDto dto);

    /**
     * 根据流程编码，查看月度预算调整数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetAdjustVo
     * @author huojia
     * @date 2022/11/14 15:44
     **/
    MonthBudgetMainAdjustVo adjustQuery(String processNo);

    MonthBudgetMainAdjustVo adjustSumQuery(String processNo);

    /**
     * 审批中查看 变更明细
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetChangeVo
     * @author huojia
     * @date 2022/11/14 16:23
     **/
    MonthBudgetChangeVo changeQuery(String processNo);

    /*下述三个手动触发的接口对应的定时任务，必须按照顺序执行*/

    /**
     * 手动执行计算回复量（根据月份批量执行）
     *
     * @param ids
     * @param planFlag
     * @author huojia
     * @date 2022/11/16 16:14
     **/
    void manualReplay(List<String> ids, String planFlag);

    /**
     * 销管资金池预算项目计算回复量
     *
     * @param ids
     */
    void manualRestoreReplayReimburse(List<String> ids);

    /**
     * 销管资金池预算项目计算回复差
     *
     * @param ids
     */
    void manualActualReplayDiffReimburse(List<String> ids);

    /**
     * 其他预留项目预算项目计算（计划、回复）量
     *
     * @param ids
     */
    void manualRestoreReplayOthers(List<String> ids, String planFlag);

    /**
     * 其他预留项目预算项目计算回复差
     *
     * @param ids
     */
    void manualActualReplayDiffOthers(List<String> ids);

    /**
     * 特仑苏统筹和授权预算项目计算回复量
     *
     * @param ids
     */
    void manualRestoreReplayRestoreDeluxu(List<String> ids);

    /**
     * 特仑苏统筹和授权预算项目计算月度实销回复差
     *
     * @param ids
     */
    void manualActualReplayDiffDeluxuMonth(List<String> ids);

    /**
     * 特仑苏统筹和授权预算项目计算季度实销回复差
     *
     * @param ids
     */
    void manualActualReplayDiffDeluxuQuarter(List<String> ids);

    /**
     * 手动执行计算回复量（根据月份批量执行）
     *
     * @author huojia
     * @date 2023/1/31 20:51
     * @param yearMonth
     * @param planFlag
     **/
    void manualReplayYearMonth(String yearMonth, String planFlag, AbstractCrmUserIdentity crmUserIdentity);

    /**
     * 手动执行实销量与回复量差额（根据月份批量执行）
     *
     * @param ids
     * @return null
     * @author huojia
     * @date 2022/11/16 15:14
     **/
    void manualActualReplayDiff(List<String> ids);

    /**
     * 手动执行滚动
     *
     * @param ids
     * @author huojia
     * @date 2022/11/5 20:11
     **/
    void manualRolling(List<String> ids);

    /**
     * 批量计算实销量与回复量差额
     *
     * @param ids
     * @author huojia
     * @date 2022/11/17 0:03
     **/
    void calActualReplayDiff(List<String> ids);

    /**
     * 批量计算月度滚动金额
     *
     * @param currId
     * @param lastId
     * @param rollingType
     * @author huojia
     * @date 2022/11/16 19:18
     **/
    void calRolling(String currId, String lastId, String rollingType);

    /**
     * 条件查询月度预算
     *
     * @param monthBudgetDto
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/11/22 14:46
     **/
    List<MonthBudgetVo> listByConditions(MonthBudgetDto monthBudgetDto);

    /**
     * 考核通报分页查询预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo>
     * @author huojia
     * @date 2022/11/24 17:30
     **/
    Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Pageable pageable, MonthBudgetExamineCircularQueryDto dto);

    /**
     * 商务政策查询预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo>
     * @author huojia
     * @date 2022/12/2 11:47
     **/
    Page<MonthBudgetBusinessPolicyQueryVo> findBusinessPolicyByConditions(Pageable pageable, MonthBudgetBusinessPolicyQueryDto dto);

    /**
     * 批量查询月度预算
     *
     * @param codes
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/12/20 16:37
     **/
    List<MonthBudgetVo> listByCodes(List<String> codes);

    /**
     * 批量查询月度预算
     *
     * @param codes
     * @param businessUnitCode
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/12/20 16:37
     **/
    List<MonthBudgetVo> listByCodes(List<String> codes,String businessUnitCode);

    /**
     * 批量查询月度预算
     *
     * @param codes
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo>
     * @author huojia
     * @date 2022/12/28 10:53
     **/
    List<MonthBudgetBusinessPolicyQueryVo> findBusinessPolicyByCodes(List<String> codes);

    /**
     * 根据年度预算编码批量查询月度预算
     *
     * @param yearBudgetList
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2023/1/8 17:36
     **/
    List<MonthBudgetVo> listByYearBudgetCodes(List<String> yearBudgetList);

    /**
     * 垂直定时计算指定年月的计划量
     *
     * @param yearMonth
     * @param businessUnitCodeList
     * @author huojia
     * @date 2023/1/20 21:45
     **/
    void autoPlan(String yearMonth, List<String> businessUnitCodeList);

    /**
     * 定时任务计算计算量和回复量
     * @param nextYearMonth
     * @param businessUnitCodeList
     * @param planFlag
     */
    void autoPlanReplay(String nextYearMonth, List<String> businessUnitCodeList, String planFlag);

    /**
     * 实销量计算
     *
     * @param format
     * @param businessUnitCodeList
     * @author huojia
     * @date 2023/1/20 22:46
     **/
    List<String> autoActualSales(String format, List<String> businessUnitCodeList);

    /**
     * 查询部门预算关联的客户预算
     * @param dtos
     * @return
     */
    List<MonthBudgetVo> findCustomerGroupMonthBudget(List<MonthBudgetDto> dtos);

    /**
     * 根据ids集合修改预算管控可用余额
     *
     * @param ids 主键集合
     * @param controlBalanceAmount 预算管控可用余额
     * @date 2023/1/8 17:36
     **/
    void updateControlBalanceAmountByIds(Set<String> ids,BigDecimal controlBalanceAmount);

    /**
     * 查询管控金额
     *
     * @author huojia
     * @date 2023/2/2 15:57
     * @param monthBudgetList
     * @return java.util.Map<java.lang.String,java.math.BigDecimal>
     **/
    Map<String, MonthBudgetControlVo> mapControlAmount(List<String> monthBudgetList);

    /**
     * 月度预算导入
     * @param monthBudgetDto
     */
    void importSave(MonthBudgetDto monthBudgetDto);

    /**
     * 优先计算实际销量
     * @param ids
     */
    Map<String, MonthBudgetActualSalesVo> calculateActualSales(List<String> ids);

    /**
     * 计算实销量与回复量差额
     * @param actualSales
     * @param currMonthBudget
     */
    void calculateActualReplyDiff(MonthBudgetActualSalesVo actualSales, MonthBudgetVo currMonthBudget);

    /**
     * 查询当前计算年月的月度计划
     * @param id
     * @return {@link MonthBudgetVo}
     */
    default MonthBudgetVo findCurrMonthBudgetById(String id, String yearMonthLy){
        return null;
    }

    /**
     * 核销操作预算
     * @param auditBudgetHeadVo
     */
    ChangeBudgetVo auditUseBudget(AuditBudgetHeadVo auditBudgetHeadVo);

    /**
     * 月份+业务单元查询月度预算
     * @param yearMonth
     * @param businessUnitCodeList
     * @return {@link List}<{@link String}>
     */
    default List<String> listByYearMonth(String yearMonth, List<String> businessUnitCodeList){
        return Lists.newArrayList();
    };

    /**
     * 删除
     * @param ids
     */
    default void deleteBatch(List<String> ids){

    }

    /**
     * 计算对应年月的
     * @param yearMonth
     */
    void calHeadYearTotalAvailableBalanceSyncXxlJob(String yearMonth);

    /**
     * 能力中心保存月度预算
     * @param monthBudgetDtoList
     * @return
     */
    default List<String> saveBatchForOut(List<MonthBudgetDto> monthBudgetDtoList) {
        return Lists.newArrayList();
    };

    List<MonthBudgetDetailVo> findDetailByBusinessCodes(List<String> businessCodes);

    String auditUseRetrunOperateBudget(List<String> auditDetailCodes, String auditCode);

    /**
     * 根据月度预算编码集合查询月度预算
     *
     * @param monthBudgetCodes 月度预算编码集合
     * @return List<MonthBudgetVo>
     */
    List<MonthBudgetVo> findBudgetByMonthBudgetCodes(List<String> monthBudgetCodes);

    /**
     * 更新月度预算并执行滚动
     *
     * @param dtoList 月度预算集合
     */
    void updateAndRoll(List<MonthBudgetDto> dtoList);

    Page<MonthBudgetVo> findPageForOut(Pageable pageable, MonthBudgetDto dto);

    Page<MonthBudgetVo> auditAdjustFindBudget(Pageable pageable, String customerCode);

    /**
     * 通过主键查询多条数据
     *
     * @param ids 主键
     * @return 多条条数据
     */
    List<MonthBudgetVo> findByIds(List<String> ids);

    MonthBudgetVo getOneByYearBudgetCodeAndMonth(String yearBudgetCode, String feeYearMonth);

    /**
     * 垂直区域费用预警-给帆软跑
     * @param yearMonths
     */
    void verticalAreaFeeWarning(List<String> yearMonths);

    /**
     * 主体预算整体管控查询月度预算信息
     * @param dto
     * @return
     */
    default List<MonthBudgetVo> findMonthBudgetForVariable(MonthBudgetDto dto) {
        return Lists.newArrayList();
    }

    default List<MonthBudgetVo> findMonthBudgetConditionForVariable(MonthBudgetDto monthBudgetDto) {
        return Lists.newArrayList();
    }

    MonthBudgetVo findMonthBudgetSumAuditAmount(MonthBudgetDto monthBudgetDto);

    MonthBudgetVo findMonthBudgetSumInitResolveAmount(MonthBudgetDto monthBudgetDto);


    /**
     * 垂直预警面板-给帆软跑
     * @param yearMonths
     */
    void verticalWarningPanel(List<String> yearMonths);
}
