package com.biz.crm.tpm.business.month.budget.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.month.budget.sdk.dto.*;
import com.biz.crm.tpm.business.month.budget.sdk.vo.*;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年10月31日 20:37
 */
public interface SubComMonthBudgetService {

    /**
     * 分页查询分子公司
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo>
     * @author huojia
     * @date 2022/10/31 20:50
     **/
    Page<SubComMonthBudgetVo> findByConditions(Pageable pageable, SubComMonthBudgetDto dto);

    /**
     * 通过主键查询分子公司月度预算
     *
     * @param id
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo
     * @author huojia
     * @date 2022/10/31 22:19
     **/
    SubComMonthBudgetVo findById(String id);

    /**
     * 新增分子公司月度预算
     *
     * @param dto
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo
     * @author huojia
     * @date 2022/10/31 22:21
     **/
    SubComMonthBudgetVo create(SubComMonthBudgetDto dto);

    /**
     * 编辑分子公司月度预算
     *
     * @param dto
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo
     * @author huojia
     * @date 2022/10/31 22:21
     **/
    SubComMonthBudgetVo update(SubComMonthBudgetDto dto);

    /**
     * 分子公司预算调整
     *
     * @param dto
     * @author huojia
     * @date 2022/11/2 10:45
     **/
    void adjust(SubComMonthBudgetAdjustDto dto);

    /**
     * 审批中查看调整数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetMainAdjustVo
     * @author huojia
     * @date 2022/12/23 14:20
     **/
    SubComMonthBudgetMainAdjustVo adjustQuery(String processNo);

    /**
     * 审批中查看变更数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetChangeVo
     * @author huojia
     * @date 2022/12/23 14:29
     **/
    SubComMonthBudgetChangeVo changeQuery(String processNo);

    /**
     * 变更
     *
     * @param dto
     * @author huojia
     * @date 2022/11/2 10:52
     **/
    void change(SubComMonthBudgetOperateDto dto);

    /**
     * 冻结、解冻
     *
     * @param dto
     * @param code
     * @author huojia
     * @date 2022/11/2 10:52
     **/
    void unOrFreeze(SubComMonthBudgetOperateDto dto, String code);

    /**
     * 本模块使用
     * <p>
     * 操作分子公司月度预算（月度预算编码、操作金额、操作类型必填）
     *
     * @param monthBudgetCode
     * @param operationAmount
     * @param operationType
     * @param businessCode
     * @author huojia
     * @date 2022/11/7 10:39
     **/
    void operateBudget(String monthBudgetCode, BigDecimal operationAmount, String operationType, String businessCode);

    /**
     * 本模块使用
     * <p>
     * 批量操作分子公司月度预算（月度预算编码、操作金额、操作类型必填）
     *
     * @author wanghaojia
     * @date 2023/1/9 16:35
     **/
    void operateBudget(List<OperateMonthBudgetDto> operateList);

    /**
     * 核销推预算
     * @param operateList
     */
    void operateBudgetByAudit(List<OperateMonthBudgetDto> operateList, Map<String, MonthBudgetControlVo> controlMap);


    /**
     * 分子公司划拨
     *
     * @param dto
     * @author huojia
     * @date 2022/11/8 10:35
     **/
    void transfer(SubComMonthBudgetTransferDto dto);

    /**
     * 根据预算项目编码查询分子公司月度预算
     *
     * @param budgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo>
     * @author huojia
     * @date 2022/11/12 11:54
     **/
    List<SubComMonthBudgetVo> listByBudgetItemCodeList(List<String> budgetItemCodeList);

    /**
     * 根据预算编码查询分子公司月度预算
     *
     * @param budgetCodeList
     * @return
     */
    List<SubComMonthBudgetVo> listByBudgetCodeList(List<String> budgetCodeList);

    /**
     * 手动执行滚动
     *
     * @param ids
     * @author huojia
     * @date 2022/11/23 20:03
     **/
    void manualRolling(List<String> ids);

    /**
     * 计算滚动金额
     *
     * @param ids
     * @author huojia
     * @date 2022/11/23 20:13
     **/
    void calRolling(List<String> ids);

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo>
     * @author huojia
     * @date 2022/11/24 23:58
     **/
    Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Page<MonthBudgetExamineCircularQueryVo> page, MonthBudgetExamineCircularQueryDto dto);

    /**
     * 分子公司活动规划生成分子公司月度预算
     *
     * @param subComMonthBudgetDtoList
     * @author huojia
     * @date 2022/12/8 23:12
     **/
    List<SubComMonthBudgetVo> designMonthBudget(List<SubComMonthBudgetDto> subComMonthBudgetDtoList);

    /**
     * 大批量保存
     *
     * @param importList 导入数据列表
     */
    void bulkImportSave(List<SubComMonthBudgetDto> importList);

    /**
     * 通过预算编码集合查询
     */
    List<SubComMonthBudgetVo> listByCodes(List<String> codes);

    /**
     * 删除数据（仅能删除手动新增的）
     * @param ids
     */
    void delete(List<String> ids);

    /**
     * 条件查询分子预算
     * @param subComMonthBudgetDto
     * @return
     */
    List<SubComMonthBudgetVo> findListByCondition(SubComMonthBudgetDto subComMonthBudgetDto);

    /**
     * 根据分子预算预测更新分子月度预算
     *
     * @param forecastMap 维度map
     */
    void updateSubComMonthBudgetByBudgetForecast(Map<String, BigDecimal> forecastMap);

    Page<SubComMonthBudgetVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode);

}
