package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityDetailPlanItemVo2", description = "活动明细")
public class ActivityDetailPlanItemVo2 extends TenantFlagOpVo {
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商编码")
    private String systemCode;

    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    private String budgetItemCode;
}
