package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @Description: 预算明细
 * @Author: dengwei
 * @Date: 2023/3/1 10:35
 * @Version: 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditBudgetItemVo", description = "预算明细")
public class AuditBudgetItemVo extends TenantFlagOpVo {

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;
    private String feeSourceName;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;
    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    @ApiModelProperty(value = "本次使用金额", notes = "")
    private BigDecimal useAmount;

    @ApiModelProperty("预算回退金额")
    private BigDecimal rollbackAmount;

    /************************分子公司**************************/
    @ApiModelProperty(name = "费用来源[数据字典:tpm_fee_source]", notes = "")
    private String feeSourceCode;

    /**
     * 关闭金额
     */
    @ApiModelProperty("关闭金额")
    private BigDecimal closeAmount;
}
