package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SonComBugdetDimensionalityDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.AuditUseBudgetTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 核销处理预算vo
 * @Author: dengwei
 * @Date: 2023/3/1 0:41
 * @Version: 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditBudgetVo", description = "核销处理预算vo")
public class AuditBudgetVo extends TenantFlagOpVo {

    @ApiModelProperty("预估超额")
    private BigDecimal overBudgetAmount;

    private List<String> detailPlanItemCodes;

    @ApiModelProperty("方案退预算发生年月")
    private String planReturnBudgetYearAndMonth;
    /**
     * 操作预算的金额
     */
    private BigDecimal amount;

    /**
     * 已结案金额
     */
    private BigDecimal alreadyEndCaseAmount;

    /**
     * 使用预算类型
     */
    private AuditUseBudgetTypeEnum type;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditDetailCode;

    /**
     * 预算明细
     */
    private List<AuditBudgetItemVo> budgetItems;

    /**
     * 分子公司预算预测的预算
     */
    private List<AuditDesignBudgetItemVo> designBudgetItems;


    private SonComBugdetDimensionalityDto detailPlanItemVo;

    private ActivityDetailPlanItemVo2 planItemVo;
}
