package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 分子公司活动规划的预算预测
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditDesignBudgetItemVo", description = "分子公司活动规划的预算预测")
public class AuditDesignBudgetItemVo extends TenantFlagOpVo {
    /**
     * 活动规划编码
     */
    @ApiModelProperty(value = "活动规划编码", notes = "")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(value = "活动规划名称", notes = "")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(value = "活动规划明细编码", notes = "")
    private String activityDesignDetailCode;

    /**
     * 活动方案、活动细案编码
     */
    @ApiModelProperty(value = "活动方案、活动细案编码", notes = "")
    private String planCode;

    /**
     * 活动方案、活动细案名称
     */
    @ApiModelProperty(value = "活动方案、活动细案名称", notes = "")
    private String planName;

    /**
     * 活动方案、活动细案明细编码
     */
    @ApiModelProperty(value = "活动方案、活动细案明细编码", notes = "")
    private String planDetailCode;

    /**
     * 关联类型编码[数据字典:tpm_relation_type]
     */
    @ApiModelProperty(value = "关联类型编码[数据字典:tpm_relation_type]", notes = "")
    private String associationType;
    /**
     * 承接类型编码
     */
    @ApiModelProperty("承接方式")
    private String undertakingMode;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;


    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(name = "分子公司预算预测编码")
    private String budgetForecastCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "费用来源[数据字典:tpm_fee_source]", notes = "")
    private String feeSourceCode;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    private BigDecimal budgetAmount;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    private BigDecimal downAmount;

    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    private String isAllDown;
}
