package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/**
 * @Description 月度预算计算实际销量Vo
 * @Author YangWei
 * @Date 2023/2/17 下午5:12
 */
@Getter
@Setter
public class MonthBudgetActualSalesVo extends TenantFlagOpVo {
    private static final long serialVersionUID = 6573829101034790873L;

    /**
     * 预算类型
     */
    @ApiModelProperty(value = "预算类型")
    private String budgetType;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元")
    private String businessUnitCode;

    /**
     * 年度预算编码
     */
    @ApiModelProperty(value = "年度预算编码", notes = "")
    private String yearBudgetCode;

    /**
     * 月度预算编码
     */
    @ApiModelProperty(value = "月度预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 预算点数
     */
    @ApiModelProperty(value = "预算点数")
    private BigDecimal budgetTotalPoint;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 管控类型[数据字典:tpm_budget_control_type]
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    private String controlTypeCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 部门归口[数据字典:tpm_department_belong]
     */
    @ApiModelProperty(value = "部门归口[数据字典:tpm_department_belong]", notes = "")
    private String departmentBelongCode;

    /**
     * 预算计算配置
     */
    private BudgetCalConfigVo budgetCalConfigVo;

    /**
     * 月度分解金额
     */
    private BigDecimal firstReplyAmount;

    /**
     * 回滚类型
     */
    private String rollingType;

    /**
     * 是否回滚
     * BooleanEnum.TRUE.getCapital()
     */
    private String rolling = "N";

    /**
     * 实销金额
     */
    private BigDecimal actualSales;

    /**
     * 实销金额
     */
    private BigDecimal actualSalesAmount;

    /**
     * 实际费用
     */
    private BigDecimal actualCostsAmount;

    /**
     * 定时任务执行的特殊日期，计算时有个判断需要用到
     */
    private String DAY;

    /**
     * 计算数据（计划量/回复量）
     */
    @ApiModelProperty(value = "计算数据", notes = "")
    private BigDecimal calAmount;

    /**
     * 年度力度-分子
     */
    @ApiModelProperty(name = "年度力度-分子", notes = "")
    private BigDecimal budgetIntensityNumerator;
    /**
     * 年度力度-分母
     */
    @ApiModelProperty(name = "年度力度-分母", notes = "")
    private BigDecimal budgetIntensityDenominator;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;
}