package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年12月02日 11:28
 */
@ApiModel(value = "MonthBudgetBusinessPolicyQueryVo", description = "TPM-商务政策查询预算vo")
@Getter
@Setter
public class MonthBudgetBusinessPolicyQueryVo extends MonthBudgetVo {

    /**
     * 一级预算项目编码
     */
    @ApiModelProperty(value = "一级预算项目编码")
    private String firstBudgetItemCode;

    /**
     * 一级预算项目名称
     */
    @ApiModelProperty(value = "一级预算项目名称")
    private String firstBudgetItemName;

    /**
     * 二级预算项目编码
     */
    @ApiModelProperty(value = "二级预算项目编码")
    private String secondBudgetItemCode;

    /**
     * 二级预算项目名称
     */
    @ApiModelProperty(value = "二级预算项目名称")
    private String secondBudgetItemName;

    /**
     * 二级预算项目可用余额
     */
    @ApiModelProperty(value = "二级预算项目可用余额")
    private BigDecimal secondBudgetItemBalance;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额")
    private BigDecimal usedAmount;

    /**
     * 使用VS管控
     */
    @ApiModelProperty(value = "使用VS管控")
    private BigDecimal usedVsControl;

    /**
     * 费用率
     */
    @ApiModelProperty(value = "费用率")
    private BigDecimal feeRatio;

    /**
     * 业务编号
     */
    @ApiModelProperty(name = "businessCode",notes = "业务编号", value = "业务编号")
    private String businessCode;
}
