package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 20:10
 */
@ApiModel(value = "MonthBudgetControlVo", description = "TPM-月度预算管控vo")
@Getter
@Setter
public class MonthBudgetControlVo {

    @ApiModelProperty(value = "管控编码")
    private String controlsConfigCode;

    /**
     * 月度预算编码
     */
    @ApiModelProperty(value = "月度预算编码")
    private String monthBudgetCode;

    /**
     * 管控形势[数据字典:control_situation]
     */
    @ApiModelProperty("管控形势[数据字典:control_situation]")
    private String controlSituation;

    /**
     * 管控类型
     */
    @ApiModelProperty("管控类型")
    private String controlTypeCode;

    /**
     * 预算管控可用余额
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    private BigDecimal controlBalanceAmount;

    /**
     * 管控率
     */
    @ApiModelProperty(value = "管控率", notes = "")
    private BigDecimal controlRatio;

    @ApiModelProperty("是否滚动")
    private String ifRolling;

    @ApiModelProperty("管控口径")
    private String controlsCaliber;

}
