package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author huojia
 * @date 2022年10月27日 20:10
 */
@ApiModel(value = "MonthBudgetExamineCircularQueryVo", description = "TPM-月度预算-考核通报vo")
@Getter
@Setter
public class MonthBudgetExamineCircularQueryVo extends TenantFlagOpVo {

    /**
     * 月度预算编码
     */
    @ApiModelProperty(value = "月度预算编码")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元")
    private String businessUnitCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 组织层级
     */
    @ApiModelProperty(value = "组织层级", notes = "")
    private String orgLevelCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]")
    private String budgetItemLevelCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级")
    private String salesOrgLevelCode;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

}
