package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @Description 月度预算主体更新导入VO
 * @Author YangWei
 * @Date 2023/2/2 下午4:18
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class MonthBudgetImportsHeadVo extends CrmExcelVo {
    /**
     * 月度预算编码
     */
    @CrmExcelColumn(value = "*月度预算编码")
    @ApiModelProperty(value = "月度预算编码")
    private String monthBudgetCode;


    /**
     * 计划量/回复量
     */
    @CrmExcelColumn(value = "计划量/回复量")
    @ApiModelProperty(value = "计划量/回复量", notes = "计划量/回复量")
    private String calAmountStr;

    private BigDecimal calAmount;

    /**
     * 月度分解金额
     */
    @CrmExcelColumn(value = "月度分解金额")
    @ApiModelProperty(value = "月度分解金额", notes = "月度分解金额")
    private String firstReplyAmountStr;

    /**
     * 月度分解金额与年初分解金额的差异
     */
    @CrmExcelColumn(value = "月度分解金额与年初分解金额的差异")
    @ApiModelProperty(value = "月度分解金额与年初分解金额的差异", notes = "月度分解金额与年初分解金额的差异")
    private String firstReplyResolveDiffAmountStr;

    /**
     * 上月滚动金额
     */
    @CrmExcelColumn(value = "上月滚动金额")
    @ApiModelProperty(value = "上月滚动金额", notes = "上月滚动金额")
    private String lastMonthRollingAmountStr;

    /**
     * 实销金额
     */
    @CrmExcelColumn(value = "实销金额")
    @ApiModelProperty(value = "实销金额", notes = "实销金额")
    private String actualSalesStr;
}