package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @Description 月度预算导入VO
 * @Author YangWei
 * @Date 2023/2/2 下午4:18
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class MonthBudgetImportsVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "* 业态")
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "* 业务单元")
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "* 年月")
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 预算项目编码
     */
    @CrmExcelColumn(value = "* 预算项目编码")
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @CrmExcelColumn(value = "预算项目名称")
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]")
    private String budgetItemLevelCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @CrmExcelColumn(value = "* 费用归口")
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]")
    private String feeBelongCode;

    /**
     * 零售商编码
     */
    @CrmExcelColumn(value = "* 零售商编码")
    @ApiModelProperty(value = "零售商编码")
    private String systemCode;

    /**
     * 零售商名称
     */
    @CrmExcelColumn(value = "零售商名称")
    @ApiModelProperty(value = "零售商名称")
    private String systemName;

    /**
     * 区域编码
     */
    @CrmExcelColumn(value = "* 区域编码")
    @ApiModelProperty(value = "区域编码[数据字典：MDM_CUSTOMIZE_ORG]", notes = "")
    private String regionCode;

    /**
     * 区域名称
     */
    @CrmExcelColumn(value = "区域名称")
    @ApiModelProperty(value = "区域名称", notes = "")
    private String regionName;

    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码")
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmExcelColumn(value = "门店名称")
    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码")
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称")
    @ApiModelProperty(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn(value = "品类编码")
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @CrmExcelColumn(value = "品类名称")
    @ApiModelProperty(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @CrmExcelColumn(value = "品项编码")
    @ApiModelProperty(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @CrmExcelColumn(value = "品项名称")
    @ApiModelProperty(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    @ApiModelProperty(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    @ApiModelProperty(value = "产品名称")
    private String productName;

    /**
     * 费用金额
     */
    @CrmExcelColumn(value = "* 费用金额")
    @ApiModelProperty(value = "费用金额")
    private BigDecimal amount;
}