package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author huojia
 * @date 2022年10月27日 20:10
 */
@ApiModel(value = "MonthBudgetVo", description = "TPM-月度预算")
@Getter
@Setter
public class MonthBudgetVo extends TenantFlagOpVo {

    /**
     * 预算类型
     */
    @ApiModelProperty(value = "预算类型")
    private String budgetType;

    /**
     * 年度预算编码
     */
    @ApiModelProperty(value = "年度预算编码")
    private String yearBudgetCode;

    /**
     * 月度预算编码
     */
    @ApiModelProperty(value = "月度预算编码")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    @ApiModelProperty(value = "年月", notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date yearMonthDate;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]")
    private String groupCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 组织层级
     */
    @ApiModelProperty(value = "组织层级", notes = "")
    private String orgLevelCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]")
    private String budgetItemLevelCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]")
    private String feeBelongCode;

    @ApiModelProperty(value = "费用归口-中文")
    private String feeSourceName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级")
    private String salesOrgLevelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码", notes = "")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(value = "客户渠道名称", notes = "")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    private String terminalChannelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称", notes = "")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称")
    private String productName;

    /**
     * 审批中金额
     */
    @ApiModelProperty(value = "审批中金额", notes = "")
    private BigDecimal approvingAmount;

    /**
     * 预算点数
     */
    @ApiModelProperty(value = "预算点数")
    private BigDecimal budgetTotalPoint;

    /**
     * 总目标量
     */
    @ApiModelProperty(value = "总目标量")
    private BigDecimal totalGoalQuantity;

    /**
     * 年度力度
     */
    @ApiModelProperty(name = "年度力度", notes = "")
    private String budgetIntensity;

    /**
     * 年度力度-分子
     */
    @ApiModelProperty(name = "年度力度-分子", notes = "")
    private BigDecimal budgetIntensityNumerator;
    /**
     * 年度力度-分母
     */
    @ApiModelProperty(name = "年度力度-分母", notes = "")
    private BigDecimal budgetIntensityDenominator;

    /**
     * 年初分解金额（期初金额）
     */
    @ApiModelProperty(value = "年初分解金额（期初金额）")
    private BigDecimal initResolveAmount;

    /**
     * 首次回复预算金额
     */
    @ApiModelProperty(value = "首次回复预算金额")
    private BigDecimal firstReplyAmount;

    /**
     * 计算数据
     */
    @ApiModelProperty(value = "计算数据", notes = "")
    private BigDecimal calAmount;

    /**
     * 首次回复预算金额与年初分解金额（期初金额）的差异
     */
    @ApiModelProperty(value = "首次回复预算金额与年初分解金额（期初金额）的差异")
    private BigDecimal firstReplyResolveDiffAmount;

    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "上月滚动金额")
    private BigDecimal lastMonthRollingAmount;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustAmount;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额")
    private BigDecimal freezeAmount;


    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额")
    private BigDecimal afterFreezeAmount;

    /**
     * 批复金额
     */
    @ApiModelProperty(value = "批复金额")
    private BigDecimal approvedAmount;

    /**
     * 预核销金额
     */
    @ApiModelProperty(value = "预核销金额")
    private BigDecimal preAuditAmount;

    /**
     * 预估超额
     */
    @ApiModelProperty(value = "预估超额")
    private BigDecimal estimatedExcessAmount;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 可用费率
     */
    @ApiModelProperty(value = "可用费率")
    private BigDecimal availableRatio;

    /**
     * 月度滚动金额
     */
    @ApiModelProperty(value = "月度滚动金额")
    private BigDecimal monthRollingAmount;

    /**
     * 月度结余金额
     */
    @ApiModelProperty(value = "月度结余金额")
    private BigDecimal monthBalanceAmount;

    /**
     * 过程回复预算金额
     */
    @ApiModelProperty(value = "过程回复预算金额")
    private BigDecimal processReplyBudgetAmount;

    /**
     * 过程回复预算与年初分解预算的差异
     */
    @ApiModelProperty(value = "过程回复预算与年初分解预算的差异")
    private BigDecimal processReplyResolveDiffAmount;

    /**
     * 过程参考可用余额
     */
    @ApiModelProperty(value = "过程参考可用余额")
    private BigDecimal processReferenceAmount;

    /**
     * 预算偏差
     */
    @ApiModelProperty(value = "预算偏差")
    private BigDecimal processOffsetAmount;

    /*调整时使用*/

    @ApiModelProperty(value = "调出金额")
    private BigDecimal adjustOutAmount;

    @ApiModelProperty(value = "调出后余额")
    private BigDecimal adjustOutBalance;

    @ApiModelProperty(value = "调入金额")
    private BigDecimal adjustInAmount;

    @ApiModelProperty(value = "调入后余额")
    private BigDecimal adjustInBalance;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 可使用策略金额
     */
    @ApiModelProperty(value = "可使用策略金额", notes = "")
    private BigDecimal usableStrategyAmount;

    /**
     * 预算管控可用余额
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    private BigDecimal controlBalanceAmount;

    /**
     * 管控形势[数据字典:control_situation]
     */
    @ApiModelProperty("管控形势[数据字典:control_situation]")
    private String controlSituation;


    /******************冗余**********************/
    @ApiModelProperty("部门预算编码")
    private String departMonthBudgetCode;

    /**
     * 管控类型
     */
    @ApiModelProperty("管控类型")
    private String controlTypeCode;

    /**
     * 管控配置编码
     */
    @ApiModelProperty("管控配置编码")
    private String controlsConfigCode;

    /**
     * 管控率
     */
    @ApiModelProperty(value = "管控率", notes = "")
    private BigDecimal controlRatio;
    /**
     * 结案金额
     */
    @ApiModelProperty("结案金额")
    private BigDecimal auditAmount;
    /**
     * 批复结案差
     */
    @ApiModelProperty("批复结案差")
    private BigDecimal approvedAuditDiff;

    /**
     * 年度累计可用金额
     */
    @ApiModelProperty("年度累计可用金额")
    private BigDecimal yearTotalAvailableAmount;

    /**
     * 实际费用
     */
    @ApiModelProperty("实际费用")
    private BigDecimal actualCosts;

    /**
     * 实销回复差
     */
    @ApiModelProperty("实销回复差")
    private BigDecimal actualReplyDiff;

    /**
     * 实销金额
     */
    @ApiModelProperty(value = "实销金额", notes = "")
    private BigDecimal actualSales;

    /**
     * 计费实销量
     */
    @ApiModelProperty(value = "计费实销量", notes = "")
    private BigDecimal billActualSales;
}
