package com.biz.crm.tpm.business.month.budget.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年11月14日 15:42
 */
@ApiModel(value = "MonthBudgetChangeVo", description = "TPM-月度预算变更bpm查看vo")
@Getter
@Setter
public class SubComMonthBudgetChangeVo {

    /**
     * 分子公司月度预算编码
     */
    @ApiModelProperty(value = "分子公司月度预算编码")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]")
    private String groupCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]")
    private String budgetItemLevelCode;

    /**
     * 归口[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "归口[数据字典:tpm_fee_source]")
    private String feeSourceCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级")
    private String orgLevelCode;

    /**
     * 渠道层级
     */
    @ApiModelProperty(value = "渠道层级")
    private String channelLevelCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称")
    private String productName;

    /**
     * 预算点数
     */
    @ApiModelProperty(value = "预算点数")
    private BigDecimal budgetTotalPoint;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额")
    private BigDecimal budgetAmount;

    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "上月滚动金额")
    private BigDecimal lastMonthRollingAmount;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustAmount;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额")
    private BigDecimal freezeAmount;

    /**
     * 批复金额
     */
    @ApiModelProperty(value = "批复金额")
    private BigDecimal approvedAmount;

    /**
     * 向上结案差
     */
    @ApiModelProperty(value = "向上结案差")
    private BigDecimal upAuditDiffAmount;

    /**
     * 本期结余金额
     */
    @ApiModelProperty(value = "本期结余金额")
    private BigDecimal currentBalanceAmount;

    /*调整时使用*/

    /**
     * 操作类型[数据字典:tpm_budget_operation_type]
     */
    @ApiModelProperty(value = "操作类型[数据字典:tpm_budget_operation_type]")
    private String operationType;

    /**
     * 变更金额
     */
    @ApiModelProperty(value = "变更金额")
    private BigDecimal changeAmount;

    /**
     * 变更后余额
     */
    @ApiModelProperty(value = "变更后余额")
    private BigDecimal changeBalance;

}
