package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 分子公司月度预算明细导出vo
 *
 * @author chenlong
 * @date 2023/2/3
 */
@Data
@ApiModel(value = "SubComMonthBudgetDetailExportVo", description = "分子公司月度预算明细导出vo")
@CrmExcelExport
public class SubComMonthBudgetDetailExportVo extends CrmExcelVo {

  /**
   * 操作类型 [数据字典:tpm_budget_operation_type]
   */
  @CrmExcelColumn("操作类型")
  private String operationType;


  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @CrmExcelColumn(value = "业务单元[数据字典:mdm_business_unit]")
  private String businessUnitCode;

  /**
   * 预算项目
   */
  @CrmExcelColumn("预算项目")
  private String budgetItemName;

  /**
   * 销售机构
   */
  @CrmExcelColumn("销售机构")
  private String salesInstitutionName;

  /**
   * 销售部门
   */
  @CrmExcelColumn("销售部门")
  private String salesRegionName;

  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  private String customerName;

  /**
   * 门店名称
   */
  @CrmExcelColumn("门店名称")
  private String terminalName;

  /**
   * 期初金额
   */
  @CrmExcelColumn("期初金额")
  private String initialAmount;

  /**
   * 操作前余额
   */
  @CrmExcelColumn("操作前余额")
  private String beforeAmount;

  /**
   * 当前操作金额
   */
  @CrmExcelColumn("当前操作金额")
  private String curOperationAmount;

  /**
   * 操作后余额
   */
  @CrmExcelColumn("操作后余额")
  private String balanceAmount;

  /**
   * 备注
   */
  @CrmExcelColumn("备注")
  private String remark;

  /**
   * 操作人
   */
  @CrmExcelColumn("操作人")
  private String createName;

  /**
   * 操作时间
   */
  @CrmExcelColumn("操作时间")
  private String createTime;
}
