package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 20:03
 */
@ApiModel(value = "SubComMonthBudgetDetailVo", description = "TPM-分子公司月度预算明细")
@Getter
@Setter
public class SubComMonthBudgetDetailVo extends TenantFlagOpVo {

    /**
     * 审批编码
     */
    @ApiModelProperty(value = "审批编码", notes = "")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态", notes = "")
    private String processStatus;

    /**
     * 分子公司预算编码
     */
    @ApiModelProperty(value = "分子公司预算编码")
    private String monthBudgetCode;

    /**
     * 操作类型[数据字典:tpm_budget_operation_type]
     */
    @ApiModelProperty(value = "操作类型[数据字典:tpm_budget_operation_type]")
    private String operationType;

    /**
     * 业务编码
     */
    @ApiModelProperty(value = "业务编码", notes = "")
    private String businessCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    /**
     * 期初金额
     */
    @ApiModelProperty(value = "期初金额")
    private BigDecimal initialAmount;

    /**
     * 操作前金额
     */
    @ApiModelProperty(value = "操作前金额")
    private BigDecimal beforeAmount;

    /**
     * 当前操作金额
     */
    @ApiModelProperty(value = "当前操作金额")
    private BigDecimal curOperationAmount;

    /**
     * 操作后余额
     */
    @ApiModelProperty(value = "操作后余额")
    private BigDecimal balanceAmount;

}
