package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Description 分子月度预算导入VO
 * @Author YangWei
 * @Date 2023/2/2 下午4:18
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class SubComMonthBudgetImportsVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "*业态")
    @ApiModelProperty(name = "businessFormatCode", value = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "*业务单元")
    @ApiModelProperty(name = "businessUnitCode", value = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "*年月")
    @ApiModelProperty(name = "yearMonthLy", value = "年月", notes = "年月")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @CrmExcelColumn(value = "*分组")
    @ApiModelProperty(name = "yearMonthLy", value = "分组[数据字典:tpm_group_code]", notes = "分组[数据字典:tpm_group_code]")
    private String groupCode;


    /**
     * 组织编码
     */
    @CrmExcelColumn(value = "*组织编码")
    @ApiModelProperty(name = "orgCode", value = "组织编码", notes = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmExcelColumn(value = "组织名称")
    @ApiModelProperty(name = "orgName", value = "组织名称", notes = "组织名称")
    private String orgName;

    /**
     * 所属销售机构编码
     */
    @CrmExcelColumn(value = "*销售机构编码")
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构名称
     */
    @CrmExcelColumn(value = "销售机构名称")
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    /**
     * 销售部门编码
     */
    @CrmExcelColumn(value = "销售部门编码")
    @ApiModelProperty(name = "salesRegionCode", value = "销售部门编码", notes = "销售部门编码")
    private String salesRegionCode;

    /**
     * 销售部门名称
     */
    @CrmExcelColumn(value = "销售部门名称")
    @ApiModelProperty(name = "salesRegionName", value = "销售部门名称", notes = "销售部门名称")
    private String salesRegionName;

    /**
     * 销售组编码
     */
    @CrmExcelColumn(value = "销售组编码")
    @ApiModelProperty(name = "salesOrgCode", value = "销售组编码", notes = "销售组编码")
    private String salesOrgCode;

    /**
     * 销售组名称
     */
    @CrmExcelColumn(value = "销售组名称")
    @ApiModelProperty(name = "salesOrgName", value = "销售组名称", notes = "销售组名称")
    private String salesOrgName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn(value = "渠道编码")
    @ApiModelProperty(name = "channelCode", value = "渠道编码", notes = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn(value = "渠道名称")
    @ApiModelProperty(name = "channelName", value = "渠道名称", notes = "渠道名称")
    private String channelName;

    /**
     * 预算项目编码
     */
    @CrmExcelColumn(value = "*预算项目编码")
    @ApiModelProperty(name = "budgetItemCode", value = "预算项目编码", notes = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @CrmExcelColumn(value = "预算项目名称")
    @ApiModelProperty(name = "budgetItemName", value = "预算项目名称", notes = "预算项目名称")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @CrmExcelColumn(value = "*费用来源")
    @ApiModelProperty(name = "feeSourceCode", value = "费用来源[数据字典:tpm_fee_source]", notes = "费用来源[数据字典:tpm_fee_source]")
    private String feeSourceCode;

    /**
     * 系统编码
     */
    @CrmExcelColumn(value = "系统编码")
    @ApiModelProperty(name = "systemCode", value = "系统编码", notes = "系统编码")
    private String systemCode;

    /**
     * 系统名称
     */
    @CrmExcelColumn(value = "系统名称")
    @ApiModelProperty(name = "systemName", value = "系统名称", notes = "系统名称")
    private String systemName;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    @ApiModelProperty(name = "customerCode", value = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    @ApiModelProperty(name = "customerName", value = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码")
    @ApiModelProperty(value = "terminalCode", notes = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmExcelColumn(value = "门店名称")
    @ApiModelProperty(value = "terminalName", notes = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn(value = "品牌编码")
    @ApiModelProperty(value = "productBrandCode", notes = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn(value = "品牌名称")
    @ApiModelProperty(value = "productBrandName", notes = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn(value = "品类编码")
    @ApiModelProperty(value = "productCategoryCode", notes = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @CrmExcelColumn(value = "品类名称")
    @ApiModelProperty(value = "productCategoryName", notes = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @CrmExcelColumn(value = "品项编码")
    @ApiModelProperty(value = "productItemCode", notes = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @CrmExcelColumn(value = "品项名称")
    @ApiModelProperty(value = "productItemName", notes = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    @ApiModelProperty(value = "productCode", notes = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    @ApiModelProperty(value = "productName", notes = "产品名称")
    private String productName;

    /**
     * 预算金额
     */
    @CrmExcelColumn(value = "*预算金额")
    @ApiModelProperty(value = "budgetAmountStrStr", notes = "预算金额")
    private String budgetAmountStr;
}