package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 18:59
 */
@ApiModel(value = "SubComMonthBudgetPlanBudgetVo", description = "TPM-分子公司月度预算方案、细案预算明细")
@Getter
@Setter
public class SubComMonthBudgetPlanBudgetVo extends TenantFlagOpVo {

    /**
     * 分子公司预算编码
     */
    @ApiModelProperty(value = "分子公司预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    private String activityDesignDetailCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 活动方案、活动细案编码
     */
    @ApiModelProperty(value = "活动方案、活动细案编码", notes = "")
    private String planCode;

    /**
     * 活动方案、活动细案名称
     */
    @ApiModelProperty(value = "活动方案、活动细案名称", notes = "")
    private String planName;

    /**
     * 活动方案、活动细案明细编码
     */
    @ApiModelProperty(value = "活动方案、活动细案明细编码", notes = "")
    private String planDetailCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用金额
     */
    @ApiModelProperty("费用金额")
    private BigDecimal budgetAmount;
}
