package com.biz.crm.tpm.business.month.budget.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月31日 20:47
 */
@ApiModel(value = "SubComMonthBudgetVo", description = "TPM-分子公司月度预算")
@Getter
@Setter
public class SubComMonthBudgetVo extends TenantFlagOpVo {

    /**
     * 分子公司月度预算编码
     */
    @ApiModelProperty(value = "分子公司月度预算编码")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]")
    private String groupCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]")
    private String budgetItemLevelCode;

    /**
     * 归口[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "归口[数据字典:tpm_fee_source]")
    private String feeSourceCode;
    /**
     * 归口名字
     */
    @ApiModelProperty(value = "归口名字", notes = "")
    private String feeSourceName;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构erp编码
     */
    @ApiModelProperty("所属销售机构erp编码")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    /**
     * 销售大区编码
     */
    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    /**
     * 销售大区erp编码
     */
    @ApiModelProperty("所属销售大区erp编码")
    private String salesRegionErpCode;

    /**
     * 销售大区名称
     */
    @ApiModelProperty("所属销售大区名称")
    private String salesRegionName;

    /**
     * 所属销售组织(组)编码
     */
    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    /**
     * 所属销售组织(组)erp编码
     */
    @ApiModelProperty("所属销售组织(组)erp编码")
    private String salesOrgErpCode;

    /**
     * 所属销售组织(组)名称
     */
    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级")
    private String orgLevelCode;

    /**
     * 渠道层级
     */
    @ApiModelProperty(value = "渠道层级")
    private String channelLevelCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称")
    private String productName;

    /**
     * 预算点数
     */
    @ApiModelProperty(value = "预算点数")
    private BigDecimal budgetTotalPoint;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额")
    private BigDecimal budgetAmount;

    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "上月滚动金额")
    private BigDecimal lastMonthRollingAmount;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustAmount;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额")
    private BigDecimal freezeAmount;

    /**
     * 批复金额
     */
    @ApiModelProperty(value = "批复金额")
    private BigDecimal approvedAmount;

    /**
     * 向上结案差
     */
    @ApiModelProperty(value = "向上结案差")
    private BigDecimal upAuditDiffAmount;

    /**
     * 本期结余金额
     */
    @ApiModelProperty(value = "本期结余金额")
    private BigDecimal currentBalanceAmount;

    /**
     * 预算分摊
     */
    @ApiModelProperty(value = "预算分摊")
    private List<SubComMonthBudgetPlanBudgetVo> planBudgetList;

    /**
     * 明细编码
     */
    @ApiModelProperty(value = "明细编码")
    private List<String> designDetailCodeList;

    /**
     * 数据来源
     */
    private String dataSource;
}
