/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingExecutorOprtType;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingType;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeCategoryVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.BusinessStrategySettingExecutor;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditActivitiesDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditCustomerDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDetailDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.pay.sdk.service.AuditService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditForActivitiesEventListener
implements ActivitiesEventListener {
    private static final Logger log = LoggerFactory.getLogger(AuditForActivitiesEventListener.class);
    @Autowired
    private AuditService auditService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired
    private CostTypeCategoryVoService costTypeCategoryVoService;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired(required=false)
    private List<BusinessStrategySettingExecutor> businessStrategySettingExecutors;

    public void onDelete(List<ActivitiesVo> vos) {
    }

    public void onEnable(List<ActivitiesVo> vos) {
    }

    public void onDisable(List<ActivitiesVo> vos) {
    }

    public void onChange(ActivitiesVo oldVo, ActivitiesVo newVo) {
    }

    public void onUpdateProcessStatus(ActivitiesVo vo, String processStatus) {
        if (ObjectUtils.isEmpty((Object)vo)) {
            return;
        }
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            String activitiesCode = vo.getActivitiesCode();
            ActivitiesVo activitiesVo = this.activitiesService.findDetailsByActivitiesCode(activitiesCode);
            List activitiesDetailVos = activitiesVo.getActivitiesDetails();
            ArrayList auditDetailDtos = Lists.newArrayList();
            BigDecimal totalApplyAmount = BigDecimal.ZERO;
            for (ActivitiesDetailVo activitiesDetailVo : activitiesDetailVos) {
                String costTypeDetailCode = activitiesDetailVo.getCostTypeDetailCode();
                CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(costTypeDetailCode);
                Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costTypeDetailVo.getDetailCode()});
                BusinessStrategySettingExecutor executor = BusinessStrategySettingExecutor.getExecutor(this.businessStrategySettingExecutors, (String)StrategySettingType.AUDIT.name());
                Validate.notNull((Object)executor, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u5339\u914d\u5230\u76f8\u5e94\u7684\u7b56\u7565\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{costTypeDetailVo.getDetailCode()});
                boolean autoAudit = executor.matchedOprtType(costTypeDetailVo.getSettingStrategies(), StrategySettingExecutorOprtType.AUTO_AUDIT.name(), (Object)false);
                if (!autoAudit) continue;
                CostTypeCategoryVo costTypeCategoryVo = this.costTypeCategoryVoService.findByCode(activitiesDetailVo.getCostTypeCategoryCode());
                AuditDetailDto auditDetailDto = new AuditDetailDto();
                auditDetailDto.setActivitiesCode(vo.getActivitiesCode());
                auditDetailDto.setActivitiesName(vo.getActivitiesName());
                auditDetailDto.setActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
                auditDetailDto.setCostTypeCategoryCode(activitiesDetailVo.getCostTypeCategoryCode());
                auditDetailDto.setCostTypeCategoryName(costTypeCategoryVo.getCategoryName());
                auditDetailDto.setCostTypeDetailCode(costTypeDetailVo.getDetailCode());
                auditDetailDto.setCostTypeDetailName(costTypeDetailVo.getDetailName());
                auditDetailDto.setBudgetSubjectsCode(activitiesDetailVo.getBudgetSubjectsCode());
                auditDetailDto.setBudgetSubjectsName(activitiesDetailVo.getBudgetSubjectsName());
                auditDetailDto.setCostBudgetCode(activitiesDetailVo.getCostBudgetCode());
                auditDetailDto.setOrgCode(activitiesDetailVo.getOrgCode());
                auditDetailDto.setOrgName(activitiesDetailVo.getOrgName());
                auditDetailDto.setPayBy(activitiesDetailVo.getPayType());
                auditDetailDto.setPayByName(activitiesDetailVo.getPayTypeName());
                auditDetailDto.setApplyAmount(activitiesDetailVo.getApplyAmount());
                auditDetailDto.setAuditAmount(activitiesDetailVo.getApplyAmount());
                auditDetailDto.setAccountingSubjectsCode(costTypeCategoryVo.getBudgetSubjectsCode());
                auditDetailDto.setAccountingSubjectsName(costTypeCategoryVo.getBudgetSubjectsName());
                auditDetailDto.setIsFullAudit(BooleanEnum.TRUE.getCapital());
                AuditCustomerDto auditCustomerDto = new AuditCustomerDto();
                auditCustomerDto.setCustomerCode(activitiesDetailVo.getCustomerCode());
                auditCustomerDto.setCustomerName(activitiesDetailVo.getCustomerName());
                auditCustomerDto.setAuditAmount(activitiesDetailVo.getApplyAmount());
                auditDetailDto.setAuditCustomers((List)Lists.newArrayList((Object[])new AuditCustomerDto[]{auditCustomerDto}));
                auditDetailDtos.add(auditDetailDto);
                totalApplyAmount = totalApplyAmount.add(activitiesDetailVo.getApplyAmount());
            }
            if (CollectionUtils.isEmpty((Collection)auditDetailDtos)) {
                return;
            }
            AuditDto auditDto = new AuditDto();
            AuditActivitiesDto auditActivitiesDto = new AuditActivitiesDto();
            auditActivitiesDto.setActivitiesCode(vo.getActivitiesCode());
            auditActivitiesDto.setActivitiesName(vo.getActivitiesName() == null ? vo.getName() : vo.getActivitiesName());
            auditActivitiesDto.setBeginTime(vo.getBeginTime() == null ? vo.getStartTime() : vo.getBeginTime());
            auditActivitiesDto.setEndTime(vo.getEndTime());
            auditActivitiesDto.setCreateAccount(vo.getCreateAccount());
            auditActivitiesDto.setCreateName(vo.getCreateName());
            auditActivitiesDto.setCreateTime(vo.getCreateTime());
            auditDto.setAuditActivities((List)Lists.newArrayList((Object[])new AuditActivitiesDto[]{auditActivitiesDto}));
            auditDto.setAuditName(StringUtils.join((Object[])new String[]{auditActivitiesDto.getActivitiesName(), "-\u81ea\u52a8\u6838\u9500"}));
            auditDto.setTotalApplyAmount(totalApplyAmount);
            auditDto.setAuditDetails((List)auditDetailDtos);
            this.auditService.creatForAutoAudit(auditDto);
        }
    }
}

