/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditActivities;
import com.biz.crm.tpm.business.pay.local.mapper.AuditActivitiesMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditActivitiesDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditActivitiesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditActivitiesRepository
extends ServiceImpl<AuditActivitiesMapper, AuditActivities> {
    @Autowired
    private AuditActivitiesMapper auditActivitiesMapper;

    public Page<AuditActivitiesVo> findByConditions(Pageable pageable, AuditActivitiesDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditActivitiesMapper.findByConditions((Page<AuditActivitiesVo>)page, dto);
    }

    public List<AuditActivities> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public List<AuditActivities> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(AuditActivities::getAuditCode, (Object)auditCode)).list();
    }

    public void deleteByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(AuditActivities::getAuditCode, (Object)auditCode)).remove();
    }
}

