/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditCustomer;
import com.biz.crm.tpm.business.pay.local.mapper.AuditCustomerMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditCustomerDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditCustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditCustomerRepository
extends ServiceImpl<AuditCustomerMapper, AuditCustomer> {
    @Autowired
    private AuditCustomerMapper auditCustomerMapper;

    public Page<AuditCustomerVo> findByConditions(Pageable pageable, AuditCustomerDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditCustomerMapper.findByConditions((Page<AuditCustomerVo>)page, dto);
    }

    public List<AuditCustomer> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<AuditCustomer> findByAuditDetailCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomer::getAuditDetailCode, (Object)auditDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<AuditCustomer> findByAuditDetailCodes(Collection<String> auditDetailCodes) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomer::getAuditDetailCode, auditDetailCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByAuditDetailCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditCustomer::getAuditDetailCode, (Object)auditDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public boolean deleteByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditCustomer::getAuditCode, (Object)auditCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }
}

