/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.AuditDetail;
import com.biz.crm.tpm.business.pay.local.mapper.AuditDetailMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDetailDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditDetailRepository
extends ServiceImpl<AuditDetailMapper, AuditDetail> {
    @Autowired
    private AuditDetailMapper auditDetailMapper;

    public Page<AuditDetailVo> findByConditions(Pageable pageable, AuditDetailDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditDetailMapper.findByConditions((Page<AuditDetailVo>)page, dto);
    }

    public List<AuditDetail> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AuditDetail> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditDetail::getAuditCode, (Object)auditCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public AuditDetail findByCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (AuditDetail)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditDetail::getAuditDetailCode, (Object)auditDetailCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).set(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public boolean removeByAuditCode(String auditCode) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getAuditCode, (Object)auditCode)).set(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public boolean removeByAuditCodes(Collection<String> auditCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(AuditDetail::getAuditCode, auditCodes)).set(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public int countByCostTypeAndActivitiesDetail(String costTypeDetailCode, String activitiesDetailCode) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getCostTypeDetailCode, (Object)costTypeDetailCode)).eq(AuditDetail::getActivitiesDetailCode, (Object)activitiesDetailCode)).eq(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
    }

    public List<AuditDetail> findByActivitiesDetailCodes(String activitiesDetailCode) {
        String tenantCode = TenantUtils.getTenantCode();
        return this.auditDetailMapper.findByActivitiesDetailCodes(activitiesDetailCode, tenantCode);
    }

    public List<AuditDetail> findByExcludeActivitiesCodeAndActivitiesDetailCodes(String activitiesCode, String activitiesDetailCode) {
        String tenantCode = TenantUtils.getTenantCode();
        return this.auditDetailMapper.findByExcludeActivitiesCodeAndActivitiesDetailCodes(activitiesCode, activitiesDetailCode, tenantCode);
    }

    public void updateRefundAmount(String auditDetailCode, BigDecimal refundAmount) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode) || refundAmount == null) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getAuditDetailCode, (Object)auditDetailCode)).eq(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).set(AuditDetail::getRefundAmount, (Object)refundAmount)).update();
    }

    public Set<String> findActivitiesDetailByAuditing(Set<String> costTypeDetailCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        return this.auditDetailMapper.findActivitiesDetailByAuditing(costTypeDetailCodes, tenantCode);
    }

    public Set<String> findActivitiesDetailByFullAudit() {
        String tenantCode = TenantUtils.getTenantCode();
        return this.auditDetailMapper.findActivitiesDetailByFullAudit(tenantCode);
    }

    public boolean updateCostTypeDetailName(String costTypeDetailCode, String costTypeDetailName) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(AuditDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(AuditDetail::getCostTypeDetailCode, (Object)costTypeDetailCode)).set(AuditDetail::getCostTypeDetailName, (Object)costTypeDetailName)).update();
    }

    public Set<String> findActivitiesDetailByAudited() {
        String tenantCode = TenantUtils.getTenantCode();
        return this.auditDetailMapper.findActivitiesDetailByAudited(tenantCode);
    }
}

