/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditFiles;
import com.biz.crm.tpm.business.pay.local.mapper.AuditFilesMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditFilesDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditFilesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFilesRepository
extends ServiceImpl<AuditFilesMapper, AuditFiles> {
    @Autowired
    private AuditFilesMapper auditFilesMapper;

    public Page<AuditFilesVo> findByConditions(Pageable pageable, AuditFilesDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFilesMapper.findByConditions((Page<AuditFilesVo>)page, dto);
    }

    public List<AuditFiles> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<AuditFiles> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditFiles::getAuditCode, (Object)auditCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean removeByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(AuditFiles::getAuditCode, (Object)auditCode)).remove();
    }
}

