/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.pay.local.mapper.AuditInvoiceMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditInvoiceDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditInvoiceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditInvoiceRepository
extends ServiceImpl<AuditInvoiceMapper, AuditInvoice> {
    @Autowired
    private AuditInvoiceMapper auditInvoiceMapper;

    public Page<AuditInvoiceVo> findByConditions(Pageable pageable, AuditInvoiceDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditInvoiceMapper.findByConditions((Page<AuditInvoiceVo>)page, dto);
    }

    public List<AuditInvoice> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<AuditInvoice> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getAuditCode, (Object)auditCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditInvoice::getAuditCode, (Object)auditCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public boolean deleteByInvoiceNo(String invoiceNo) {
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditInvoice::getInvoiceNo, (Object)invoiceNo)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }
}

