/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.Account;
import com.biz.crm.tpm.business.pay.local.repository.AccountRepository;
import com.biz.crm.tpm.business.pay.local.service.AccountService;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountDto;
import com.biz.crm.tpm.business.pay.sdk.dto.log.AccountLogEventDto;
import com.biz.crm.tpm.business.pay.sdk.enums.AccountStatusEnum;
import com.biz.crm.tpm.business.pay.sdk.event.log.AccountLogEventListener;
import com.biz.crm.tpm.business.pay.sdk.vo.AccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="AccountService")
public class AccountServiceImpl
implements AccountService {
    @Autowired
    private AccountRepository accountRepository;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<Account> findByConditions(Pageable pageable, AccountDto account) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(account)) {
            account = new AccountDto();
        }
        return this.accountRepository.findByConditions(pageable, account);
    }

    @Override
    public Account findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Account)((Object)this.accountRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public List<Account> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Account>(0);
        }
        return this.accountRepository.findByIds(ids);
    }

    @Override
    public List<Account> findByActivitiesDetailCode(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<Account>(0);
        }
        return this.accountRepository.findByActivitiesDetailCode(codes);
    }

    @Override
    @Transactional
    public Account create(Account account) {
        this.createValidate(account);
        this.accountRepository.saveOrUpdate((Object)account);
        AccountVo accountVo = (AccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)account, AccountVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        accountVo.setId(null);
        AccountLogEventDto logEventDto = new AccountLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(accountVo);
        SerializableBiConsumer & Serializable onCreate = AccountLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AccountLogEventListener.class, (SerializableBiConsumer)onCreate);
        return account;
    }

    @Override
    public void createBatch(List<Account> accounts) {
        for (Account account : accounts) {
            this.createValidate(account);
        }
        this.accountRepository.saveBatch(accounts);
    }

    @Override
    @Transactional
    public Account update(Account account) {
        this.updateValidate(account);
        Account dbAccount = (Account)((Object)this.accountRepository.getById((Serializable)((Object)account.getId())));
        Validate.notNull((Object)((Object)account), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        AccountVo oldAccountVo = (AccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbAccount, AccountVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.accountRepository.saveOrUpdate((Object)account);
        AccountVo accountVo = (AccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)account, AccountVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        AccountLogEventDto logEventDto = new AccountLogEventDto();
        logEventDto.setOriginal(oldAccountVo);
        logEventDto.setNewest(accountVo);
        SerializableBiConsumer & Serializable onUpdate = AccountLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AccountLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return account;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Account> accounts = this.accountRepository.findByIds(idList);
        if (CollectionUtils.isEmpty(accounts)) {
            return;
        }
        this.accountRepository.deleteBatch(idList);
        Collection accountVos = this.nebulaToolkitService.copyCollectionByWhiteList(accounts, Account.class, AccountVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = AccountLogEventListener::onDelete;
        for (AccountVo accountVo : accountVos) {
            AccountLogEventDto logEventDto = new AccountLogEventDto();
            logEventDto.setOriginal(accountVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AccountLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    private void createValidate(Account account) {
        Validate.notNull((Object)((Object)account), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        account.setId(null);
        account.setTenantCode(TenantUtils.getTenantCode());
        account.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        account.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)account.getAccountStatus())) {
            account.setAccountStatus(AccountStatusEnum.ON.getDictCode());
            account.setAccountTime(new Date());
        }
        Validate.notNull((Object)account.getAccountCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u4e0a\u8d26\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0a\u8d26\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getAuditDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u660e\u7ec6\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getAvailableAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u53ef\u4e0a\u8d26\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getBeginTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getBudgetSubjectsCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getCostTypeCategoryCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getCostTypeDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(Account account) {
        account.setTenantCode(TenantUtils.getTenantCode());
        account.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        account.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)account.getAccountStatus())) {
            account.setAccountStatus(AccountStatusEnum.ON.getDictCode());
            account.setAccountTime(new Date());
        }
        Validate.notNull((Object)((Object)account), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getAccountCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u4e0a\u8d26\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getActivitiesCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0a\u8d26\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getAuditCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getAuditDetailCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u660e\u7ec6\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getBeginTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getBudgetSubjectsCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getCostTypeCategoryCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)account.getCostTypeDetailCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)account.getEndTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

