/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.biz.crm.tpm.business.pay.local.repository.AuditDetailWithCustomerVoRepository;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDetailDto;
import com.biz.crm.tpm.business.pay.sdk.service.AuditDetailWithCustomerVoService;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailWithCustomerVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditDetailWithCustomerVoServiceImpl
implements AuditDetailWithCustomerVoService {
    @Autowired
    private AuditDetailWithCustomerVoRepository auditDetailWithCustomerVoRepository;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;

    public List<AuditDetailWithCustomerVo> getAuditDetailWithCustomer(AuditDetailDto dto) {
        List<Object> auditDetailWithCustomer = this.auditDetailWithCustomerVoRepository.getAuditDetailWithCustomer(dto);
        if (CollectionUtils.isEmpty(auditDetailWithCustomer)) {
            return new ArrayList<AuditDetailWithCustomerVo>(0);
        }
        List<String> auditCodes = auditDetailWithCustomer.stream().map(AuditDetailWithCustomerVo::getAuditCode).collect(Collectors.toList());
        List<ProcessBusinessMappingVo> processBusinessMappingVo = this.findProcessBusinessMappingVo(auditCodes);
        if (CollectionUtils.isEmpty(processBusinessMappingVo)) {
            return new ArrayList<AuditDetailWithCustomerVo>(0);
        }
        List businessNos = processBusinessMappingVo.stream().filter(item -> ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus())).map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        auditDetailWithCustomer = auditDetailWithCustomer.stream().filter(ite -> businessNos.contains(ite.getAuditCode())).collect(Collectors.toList());
        return auditDetailWithCustomer;
    }

    private List<ProcessBusinessMappingVo> findProcessBusinessMappingVo(List<String> businessNos) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setBusinessNos(businessNos);
        processBusinessMappingDto.setBusinessCode("PAY_AUDIT");
        return this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
    }
}

