/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.pay.local.repository.AuditInvoiceRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditInvoiceDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditInvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="auditInvoiceService")
public class AuditInvoiceServiceImpl
implements AuditInvoiceService {
    @Autowired
    private AuditInvoiceRepository auditInvoiceRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<AuditInvoiceVo> findByConditions(Pageable pageable, AuditInvoiceDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditInvoiceDto();
        }
        return this.auditInvoiceRepository.findByConditions(pageable, dto);
    }

    @Override
    public AuditInvoiceVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditInvoice auditInvoice = (AuditInvoice)((Object)this.auditInvoiceRepository.getById((Serializable)((Object)id)));
        if (auditInvoice == null) {
            return null;
        }
        AuditInvoiceVo auditInvoiceVo = (AuditInvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditInvoice, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditInvoiceVo;
    }

    @Override
    public List<AuditInvoiceVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByIds(ids);
        Collection auditInvoiceVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoices, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditInvoiceVos);
    }

    @Override
    public List<AuditInvoiceVo> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return Collections.emptyList();
        }
        List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(auditInvoices)) {
            return Collections.emptyList();
        }
        Collection auditInvoiceVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoices, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditInvoiceVos);
    }

    @Override
    @Transactional
    public AuditInvoiceVo create(AuditInvoiceDto auditInvoiceDto) {
        this.createValidate(auditInvoiceDto);
        AuditInvoice auditInvoice = (AuditInvoice)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditInvoiceDto, AuditInvoice.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditInvoice.setTenantCode(TenantUtils.getTenantCode());
        this.auditInvoiceRepository.saveOrUpdate((Object)auditInvoice);
        AuditInvoiceVo auditInvoiceVo = (AuditInvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditInvoice, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditInvoiceVo.setId(auditInvoice.getId());
        return auditInvoiceVo;
    }

    @Override
    @Transactional
    public List<AuditInvoiceVo> createBatch(Collection<AuditInvoiceDto> auditInvoiceDtos) {
        if (CollectionUtils.isEmpty(auditInvoiceDtos)) {
            return Lists.newArrayList();
        }
        ArrayList auditInvoiceVos = Lists.newArrayList();
        for (AuditInvoiceDto auditInvoiceDto : auditInvoiceDtos) {
            AuditInvoiceVo auditInvoiceVo = this.create(auditInvoiceDto);
            auditInvoiceVos.add(auditInvoiceVo);
        }
        return auditInvoiceVos;
    }

    @Override
    @Transactional
    public AuditInvoiceVo update(AuditInvoiceDto auditInvoiceDto) {
        this.updateValidate(auditInvoiceDto);
        AuditInvoice auditInvoice = (AuditInvoice)((Object)this.auditInvoiceRepository.getById((Serializable)((Object)auditInvoiceDto.getId())));
        Validate.notNull((Object)((Object)auditInvoice), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        AuditInvoiceVo oldAuditInvoiceVo = (AuditInvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditInvoice, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditInvoice.setAuditCode(auditInvoiceDto.getAuditCode());
        auditInvoice.setInvoiceNo(auditInvoiceDto.getInvoiceNo());
        auditInvoice.setUseAmount(auditInvoiceDto.getUseAmount());
        this.auditInvoiceRepository.saveOrUpdate((Object)auditInvoice);
        AuditInvoiceVo auditInvoiceVo = (AuditInvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditInvoice, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditInvoiceVo;
    }

    @Override
    @Transactional
    public List<AuditInvoiceVo> updateBatch(Collection<AuditInvoiceDto> auditInvoiceDtos) {
        Set currentIds;
        if (CollectionUtils.isEmpty(auditInvoiceDtos)) {
            return Collections.emptyList();
        }
        String code = auditInvoiceDtos.stream().findFirst().get().getAuditCode();
        List<AuditInvoiceVo> dbAuditInvoiceVos = this.findByAuditCode(code);
        Set dbIds = dbAuditInvoiceVos.stream().map(AuditInvoiceVo::getId).collect(Collectors.toSet());
        Sets.SetView delData = Sets.difference(dbIds, currentIds = auditInvoiceDtos.stream().map(AuditInvoiceDto::getId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)delData)) {
            this.delete((Collection<String>)delData);
        }
        List<AuditInvoiceDto> addDtos = auditInvoiceDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditInvoiceDto> updateDtos = auditInvoiceDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditInvoiceVo> auditInvoiceVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> auditInvoiceVos.add(this.update((AuditInvoiceDto)item)));
        }
        return auditInvoiceVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(auditInvoices)) {
            return;
        }
        Collection auditInvoiceVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoices, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.auditInvoiceRepository.removeByIds(ids);
    }

    @Override
    public void deleteByAuditCode(String auditCode) {
        Validate.notBlank((CharSequence)auditCode, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(auditInvoices)) {
            return;
        }
        Set ids = auditInvoices.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.auditInvoiceRepository.removeByIds(ids);
    }

    private void createValidate(AuditInvoiceDto auditInvoiceDto) {
        Validate.notNull((Object)auditInvoiceDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((auditInvoiceDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditInvoiceDto.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditInvoiceDto.getInvoiceNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u53d1\u7968\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditInvoiceDto.getUseAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AuditInvoiceDto auditInvoiceDto) {
        Validate.notNull((Object)auditInvoiceDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditInvoiceDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditInvoiceDto.getAuditCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditInvoiceDto.getInvoiceNo(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u53d1\u7968\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditInvoiceDto.getUseAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

